<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/fontawesome/css/all.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick-theme.css">
    <link rel="stylesheet" href="css/slick-edit.css">
    <link rel="stylesheet" href="css/estilos.css">
    <link rel="stylesheet" href="css/media.css">
    <link rel="stylesheet" href="css/fonts.css">
    <link rel="stylesheet" href="css/estilos-modal.css">
    <link rel="stylesheet" href="css/seccion-general.css">

    <title>IPEI "Leonardo da Vinci" - Santa Fe</title>
</head>
<body>
    <nav class="navbar fixed-top navbar-expand-lg navbar-light">
        <div class="container">
      <!-- <a class="navbar-brand" href="#">Navbar</a> -->
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item active">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item dropdown">
                        <!-- <a class="nav-link" href="historia.php">Historia</a> -->
                        <a class="nav-link dropdown-toggle" href="#" id="navbarHistoria" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Institucional <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarHistoria">
                            <a class="dropdown-item" href="institucional.php?i=historia">Historia</a>
                            <a class="dropdown-item" href="institucional.php?i=dossier">Dossier</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Docentes
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#exampleModal">Formularios</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Asistentes
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="#">Formularios</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Alumnos
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="#">Preinscripción</a>
                            <a class="dropdown-item" href="#">Reinscripción</a>
                        </div>
                    </li>
                </ul>
                <!-- <form class="form-inline my-2 my-lg-0"> -->
                  <!-- <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"> -->
                  <button class="btn btn-sm btn-primary my-2 my-sm-0" data-toggle="modal" data-target="#vacantes">ENVIÁ TU CV</button>
                  <button href="http://www.clubaunion.com.ar/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('http://www.clubaunion.com.ar/')">C.A. UNIÓN</button>
                  <button href="https://ipei.quinttos.com/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('https://ipei.quinttos.com/')">QUINTTOS</button>
                <!-- </form> -->
            </div>
      </div>
    </nav>

    <style media="screen">
        .seccion-novedades div.titulo-seccion.novedades i,
        .seccion-novedades div.titulo-seccion.novedades h3 {
            color: #1A237E;
        }

        .seccion-novedades div.card.novedad {
            margin-bottom: 10px;
        }
            .seccion-novedades div.card.novedad div.imagen-novedad{
                height: 300px;
            }

            .seccion-novedades div.card.importante {
                background-color: #FF1744;
                color: white !important;
                margin-bottom: 10px;
            }
                .seccion-novedades div.card.importante .card-title {
                    color: white !important;
                    font-weight: bold;
                }
    </style>

    <section class="seccion-banner subseccion">
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="logo-escuela">
                        <img src="img\logo_ipei_blanco.png" alt="">
                        <div class="nombre-escuela">
                            <h1>IPEI</h1>
                            <!-- <h1>Instituto Privado de Educación Integral</h1> -->
                            <h2>LEONARDO DA VINCI</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php
        $string = file_get_contents("json-novedades.json");
        $json = json_decode($string, true);
    ?>

    <section class="seccion-novedades" <?php if($_GET) echo "hidden"; ?>>
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="row">
                        <div class="col titulo-seccion">
                            <i class="fas fa-exclamation-circle"></i>
                            <h3>IMPORTANTE</h3>
                        </div>
                    </div>

                    <?php

                        for ($i=0; $i < count($json["importante"]); $i++) {

                    ?>

                    <div class="row">
                        <div class="col">
                            <div class="card importante">
                                <div class="card-body">
                                    <h5 class="card-title">
                                        <?php echo $json["importante"][$i]["titulo"] ?>
                                    </h5>
                                    <p class="card-text">
                                        <?php echo $json["importante"][$i]["cuerpo"] ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php
                        }
                    ?>

                </div>
                 <div class="col-lg-8">
                     <div class="row">
                         <div class="col titulo-seccion novedades">
                             <i class="far fa-newspaper"></i>
                             <h3>NOVEDADES</h3>
                         </div>
                     </div>
                     <!-- Comienzan las novedades -->
                     <div class="row">
                         <div class="col">
                             <div class="card novedad">
                                 <div class="imagen-novedad lazy" style="background:url('img/patio.jpg') center; background-size:cover;">
                                     <!-- <img class="card-img-top lazy" data-src="img\patio.jpg" alt="" height="100%"> -->
                                 </div>
                                 <div class="card-body">
                                     <span class="badge badge-danger">NIVEL INICIAL</span>
                                     <h5 class="card-title">Abierta la inscripción para el Nivel Inicial</h5>
                                     <i class="far fa-calendar-alt"></i><span class="card-subtitle mb-2 text-muted fecha-novedad">7 AGO 2019</span>
                                     <!-- <h5 class="card-title">Aviso importante</h5> -->
                                     <p class="card-text">Lorem ipsum dolor sit amet, consectetur adipisicing elit,
                                         quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
                                         Duis aute irure dolor in reprehenderit.</p>
                                 </div>
                             </div>
                         </div>
                     </div>
                     <div class="row">
                         <div class="col">
                             <div class="card novedad">
                                 <div class="imagen-novedad lazy" style="background:url('img/bandera.jpg') center; background-size:cover;">
                                 </div>
                                 <div class="card-body">
                                     <span class="badge badge-danger">NIVEL INICIAL</span>
                                     <h5 class="card-title">Abierta la inscripción para el Nivel Inicial</h5>
                                     <i class="far fa-calendar-alt"></i><span class="card-subtitle mb-2 text-muted fecha-novedad">7 AGO 2019</span>
                                     <!-- <h5 class="card-title">Aviso importante</h5> -->
                                     <p class="card-text">Lorem ipsum dolor sit amet, consectetur adipisicing elit,
                                         quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
                                         Duis aute irure dolor in reprehenderit.</p>
                                 </div>
                             </div>
                         </div>
                     </div>
                 </div>
            </div><br>
        </div>
    </section>

    <?php

    if($_GET) {

        $nro_novedad = $_GET["dato"];
        $error = false;

        if (isset($json["novedades"][$nro_novedad])) {
            $seccion = $json["novedades"][$nro_novedad]["seccion"];
            $titulo = $json["novedades"][$nro_novedad]["titulo"];
            $cuerpo = $json["novedades"][$nro_novedad]["cuerpo"];
        }else {
            $error = true;
            echo "Novedad no disponible! :(";
        }

        //El if se cierra luego de mostrar la novedad
    ?>

    <style media="screen">
        section.detalle-novedad {
            margin-top: 30px;
        }
            section.detalle-novedad span.badge {
                font-size: 18px;
            }
            section.detalle-novedad h1 {
                font-size: 30px;
                color: #1A237E;
            }
    </style>

    <section class="container detalle-novedad">
        <div class="row">
            <div class="col-8">
                <span class="badge badge-danger"><?php if (!$error) echo $seccion; ?></span>
                <h1><?php if (!$error) echo $titulo; ?></h1>
                <p><?php if (!$error) echo $cuerpo; ?></p>
            </div>
            <div class="col-4">

            </div>
        </div>
    </section>

    <?php
    }
    ?>

<!-- Modal Vacantes -->
    <div class="modal fade" id="vacantes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-user-plus"></i>
                    <h5 class="modal-title">VACANTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                   <p>   
                     Para ser considerado para alguna vacante que se genere en el Establecimiento enviar un curriculum vitae a la dirección de mail: cv@ipei1291.edu.ar con el
                     asunto Postulante Nivel Inicial, Postulante Nivel Primario, Postulante Nivel Secundario o Asistentes Escolares según corresponda.
                     </p>
                     <p>
                     Atte. Administración IPEI.
                   </p>
                        
                </div>
    
            </div>
        </div>
    </div>
        <!-- Modal Formularios Docentes -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-folder-open"></i>
                    <h5 class="modal-title">FORMULARIOS DOCENTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                          <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                          <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencia médica</h7><br>
                          <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencias administrativas</h7><br>
                          <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de limitación de licencia administrativa</h7><br>
                          <i class="far fa-file-alt"></i><span>LL-01.pdf</span>
                      </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="js/jquery-3.3.1.slim.min.js" charset="utf-8"></script>
    <script src="./slick/slick.js" type="text/javascript" charset="utf-8"></script>
    <script src="js/popper.min.js" charset="utf-8"></script>
    <script src="js/bootstrap.min.js" charset="utf-8"></script>
    <script src="jquery.lazy-master\jquery.lazy.js" charset="utf-8"></script>
    <script type="text/javascript">
        $(function() {
            $('.lazy').Lazy();
        });
    </script>

</body>
</html>
