<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/fontawesome/css/all.css">
    <link rel="stylesheet" href="css/fonts.css">

    <link rel="stylesheet" href="css\venobox.css" type="text/css" media="screen">

    <style>
        body {
            background: #091e6e;
        }

        a.lazyload, div.lazyload {
            height: 200px;
            background-size: cover;
            background-position: center center;
            background-color: #eee;
        }

        .vbox-share {
            display: none !important;
        }

        #banner {
            background: #f12953 !important;
        }

        @media screen and (max-width: 800px) {
            #banner img {
                width: 90%;
                margin-top: 20px;
                margin-bottom: 20px;
            }
            #felizcumple img {
                width: 100%;
            }
            div.titulo i, div.titulo h1 {
                font-size: 20px !important;
            }
        }
        div.titulo i {
            color: white;
            font-size: 30px;
            margin-right: 10px;
        }
        div.titulo h1 {
            color: white;
            font-family: Raleway-Black !important;
            font-size: 30px;
            display: inline;
        }
        
        #btn-wiki {
            background: #f12953;
            padding: 5px 20px 5px 20px;
        }
        #btn-wiki i {
            font-size: 25px;
            margin-right: 10px;
        }
        #btn-wiki h4 {
            display: inline;
        }
    </style>

    <title>IPEI "Leonardo da Vinci" - Santa Fe</title>
</head>
<body>
    <div id="banner" class="container-fluid text-center">
        <a href="nivelprimario.php">
            <img class="img-fluid" src="img\banner.jpg" alt="" width="60%">
        </a>
    </div>
    <div id="felizcumple" class="container text-center my-3">
        <img class="img-fluid" src="img\felizcumple.jpg" alt="" width="80%">
    </div>
    
    <div class="container text-center my-4 pt-4">
        <a id="btn-wiki" href="https://sites.google.com/view/cumpleipei/inicio" class="btn btn-danger">
            <i class="fas fa-birthday-cake"></i>
            <h4>UN FESTEJO ESPECIAL</h4>
        </a>
    </div>
    
    <!-- Galería -->
    <div class="container">
        <div class="row titulo text-center py-3">
            <div class="col">
                <i class="fas fa-gift"></i>
                <h1>PARTICIPANTES DEL SORTEO</h1>
            </div>
        </div>
        <div class="row">


            <?php

            $txt_links = "docs/cumplesorteo.txt";
            $link = "";

            //Leer links de las fotos en drive
            if (file_exists($txt_links) && ($fpt = fopen($txt_links, "r")) !== false) {

                while (!feof($fpt)) {
                    $link = fgets($fpt);
                    // echo preg_replace("[\n|\r|\n\r]", "12345", $link);
            ?>

                    <!-- <div class="col-lg-2 col-4 m-0 p-0"> -->
                    <div class="col-lg-2 col-4 my-1 px-1">
                        <a class="venobox" data-gall="galeria" href="http://drive.google.com/uc?export=view&id=<?php echo $link; ?>">
                            <div
                                class="col lazyload d-block rounded-lg"
                                style="background-image: url('https://drive.google.com/thumbnail?id=<?php echo $link; ?>')" 
                                data-src="https://drive.google.com/thumbnail?id=<?php echo $link; ?>">
                            </div>
                        </a>
                    </div>

            <?php
                }

                fclose($fpt);
            }

            ?>

            <div class="col-lg-2 col-4 my-1 px-1">
                <a class="venobox" data-gall="galeria" data-vbtype="iframe" href="https://drive.google.com/file/d/1E_Xmq7_iZ4tOJdhgjOc-S99ShVrKbTSJ/preview">
                    <div
                        class="col lazyload d-block rounded-lg"
                        style="background-image: url('https://lh3.googleusercontent.com/d/1E_Xmq7_iZ4tOJdhgjOc-S99ShVrKbTSJ=s220?authuser=0#t=2')" 
                        data-src="https://lh3.googleusercontent.com/d/1E_Xmq7_iZ4tOJdhgjOc-S99ShVrKbTSJ=s220?authuser=0#t=2">
                    </div>
                                
                    <!-- <img src="https://lh3.googleusercontent.com/d/1E_Xmq7_iZ4tOJdhgjOc-S99ShVrKbTSJ=s220?authuser=0#t=2" alt=""> -->
                    <!-- <video width="100%" src="http://drive.google.com/thumbnail?id=1E_Xmq7_iZ4tOJdhgjOc-S99ShVrKbTSJ#t=2" preload="metadata"></video> -->
                </a>
            </div>
        </div>
    </div>

    <script src="js/jquery-3.4.1.js" charset="utf-8"></script>
    <script src="js/popper.min.js" charset="utf-8"></script>
    <script src="js/bootstrap.min.js" charset="utf-8"></script>
    <script src="js\lazyload.js"></script>
    <script src="js\venobox.js"></script>

    <script type="text/javascript">
        $(document).ready(function(){
            $("div.lazyload").lazyload();
            $('.venobox').venobox({
                overlayClose: false,
            }); 
        });
    </script>
</body>
</html>
