<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/fontawesome/css/all.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick-theme.css">
    <link rel="stylesheet" href="css/slick-edit.css">
    <link rel="stylesheet" href="css/estilos.css">
    
    <link rel="stylesheet" href="css/fonts.css">
    <link rel="stylesheet" href="css/estilos-modal.css">
    <link rel="stylesheet" href="css/seccion-general.css">
    <link rel="stylesheet" href="css/media.css">

    <title>IPEI "Leonardo da Vinci" - Santa Fe</title>
</head>
<body>
    <!-- MENÚ -->
    <nav class="navbar fixed-top navbar-expand-lg navbar-light">
        <div class="container">
            <!-- <a class="navbar-brand" href="#">Navbar</a> -->
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item active">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="institucional.php?i=historia">Historia</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Docentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-docente">Formularios</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gob.ar/intranetv2')">Intranet Provincial</a>
                            <a class="dropdown-item" href="#" onclick="window.open('http://www.santafe.gov.ar/index.php/educacion/guia/get_tree_by_node?node_id=155232')">Portal Educación</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/index.php/educacion/content/download/251163/1319555/file/Calendario+escolar+2019+webf.pdf')">Calendario Escolar</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/gestioneducativa/#/portal')">Gestión Educativa Santa Fe</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Asistentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <!-- <a class="dropdown-item" href="#">Formularios</a> -->
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-asistentes">Formularios</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Alumnos <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="formulario.php">Preinscripción Ingresantes</a>
                            <!-- <a class="dropdown-item" href="#">Reinscripción</a> -->
                        </div>
                    </li>
                </ul>
                <!-- <form class="form-inline my-2 my-lg-0"> -->
                <!-- <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"> -->
                <!--<button class="btn btn-sm btn-primary my-2 my-sm-0" data-toggle="modal" data-target="#vacantes">ENVIÁ TU CV</button>-->
                <button href="http://www.clubaunion.com.ar/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('http://www.clubaunion.com.ar/')">C.A. UNIÓN</button>
                <button href="https://ipei.quinttos.com/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('https://ipei.quinttos.com/')">QUINTTOS</button>
                <!-- </form> -->
            </div>
        </div>
    </nav>

    <!-- BANNER -->
    <section class="seccion-banner subseccion">
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="logo-escuela">
                        <img src="img\logo_ipei_blanco.png" alt="">
                        <div class="nombre-escuela">
                            <h1>IPEI</h1>
                            <!-- <h1>Instituto Privado de Educación Integral</h1> -->
                            <h2>LEONARDO DA VINCI</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="" style="background:#1A237E; margin-bottom: 30px;">
        <div class="container">
            <div class="row">
                <div class="col titulo-seccion" style="margin: 20px 0px;">
                    <i class="fas fa-book"></i>
                    <h3>NIVEL SECUNDARIO</h3>
                </div>
            </div>
        </div>
    </div>
    
    
    <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">ESTUDIANTES CON MATERIAS PENDIENTES</h4>
                        <a href="img/novedades/MateriasPrevias.png" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                            <span>Aviso Importante</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">URGENTE - CERTIFICADOS DE VACUNACIÓN ACTUALIZADOS</h4>
                        <p> 
                        Estimada familia, el siguiente es un formulario de VACUNAS de sus hijas/os que se solicita que completen, 
                        además de enviar por mail digitalizadas las certificaciones de las mismas al mail ipeicertificaciones@gmail.com 
                        (quienes ya lo enviaron, solo deben llenar el formulario) Para ello se requiere, en primera medida, 
                        LEER CON ATENCIÓN TODAS LAS OPCIONES que contiene el mismo antes de completarlo. 
                        Está transcripto tal cual como lo solicita el Ministerio de Educación a través del SIGAE (Sistema de Gestión Administrativa Escolar) 
                        para la carga de las mismas por cada estudiante. Sólo se deberá ingresar la fecha de las vacunas que su hija/o haya recibido. 
                        Una vez realizado esto, controlar la misma antes de ENVIAR. Luego, recibirán al mail ingresado en la casilla, una copia de lo completado.
                        </b>
                        ¡Desde ya muchas gracias por la colaboración!!
                        </p>
                        <a href="https://docs.google.com/forms/d/e/1FAIpQLSdhHzgWCefScX4172Tocg1Sj3YVP3OEQztRJ1-3WJIvWuMrFQ/viewform?usp=sf_link" type="button" class="btn btn-danger" target="_blank">
                         <i class="fas fa-tasks" style="color:white;margin-right:10px;"></i>
                            <span>Formulario de VACUNAS</span>
                         </a>
                         </div>
                </div>
            </div>
        </div>
    </section>
    
       <section class="seccion-infonivel3">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">LA PLATAFORMA SCHOOLOGY</h4>
                        <p>
                        Estimados ESTUDIANTES les solicitamos que  solo ingresen a su curso con el código correspondiente, en caso contrario serán eliminados.
                        Enviamos instructivos para subir el material a cada docente, el cual, además, se encuentra disponible en la plataforma.
                        Las fechas de entregas de los trabajos están determinadas por cada docente, que lo indicó o indicará en la plataforma, 
                        en caso contrario la fecha límite para realizarla es el 31 de marzo inclusive. Las materias cuya fecha de entrega era esta semana, se extiende al 31 de marzo.

                        Saludos, equipo directivo.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <br>
>
    <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="titulo-seccion">
                        <i class="fas fa-info-circle"></i>
                        <h3>INFO DE INTERÉS</h3>
                    </div>
                    <div class="list-group destacado">
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-acceso-schoology">
                            <i class="fas fa-graduation-cap"></i>
                            <span>Acceso Plataforma Schoology</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-codigo-schoology">
                            <i class="fas fa-graduation-cap"></i>
                            <span>Còdigos Plataforma Schoology</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-instancias">
                            <i class="fas fa-graduation-cap"></i>
                            <span>Instancias para completar estudios</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-info-horario-1">
                            <i class="far fa-clock"></i>
                            <span>Horarios 1° Año - 2020</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-info-horario-2">
                            <i class="far fa-clock"></i>
                            <span>Horarios 2° Año - 2020</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-info-horario-3">
                            <i class="far fa-clock"></i>
                            <span>Horarios 3° Año - 2020</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-info-horario-4">
                            <i class="far fa-clock"></i>
                            <span>Horarios 4° Año - 2020</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-info-horario-5">
                            <i class="far fa-clock"></i>
                            <span>Horarios 5° Año - 2020</span>
                        </a>
                       <!-- <a href="#" class="list-group-item list-group-item-action">-->
                            <!-- <i class="fas fa-route"></i> -->
                        <!--    <i class="fas fa-bus-alt"></i>-->
                        <!--    <span>Plan Institucional de Salidas Educativas</span> -->
                       <!-- </a> -->
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="titulo-seccion">
                        <!-- <i class="fas fa-info-circle"></i> -->
                        <h3>¿POR QUÉ ELEGIRNOS?</h3>
                    </div>
                    <ul>
                        <li>Formación integral de personas</li>
                        <li>Responsabilidad y compromiso</li>
                        <li>Interacción con el entorno</li>
                        <li>Atención personalizada</li>
                        <li>Permanente actualización pedagógica.</li>
                        <li>Gestión colaborativa</li>
                        <li>Un solo turno (7:40 a 14:10 hs.)</li>
                        <li>Todas las actividades se desarrollan dentro del C.A.U.</li>
                        <li>Idiomas: Inglés e Italiano</li>
                        <li>Talleres</li>
                    </ul>
                    <button type="button" class="btn btn-danger btn-block" data-toggle="modal" data-target="#modal-juegos-reales">
                        <i class="fas fa-chess-rook"></i>
                        <span style="margin-left: 10px;">JUEGOS REALES</span>
                    </button>
                </div>
                <div class="col-lg-4">
                    <div class="titulo-seccion">
                        <i class="fas fa-check-square"></i>
                        <h3>REQUISITOS DE INGRESO</h3>
                    </div>
                    <ul>
                        <li>Fotocopia del DNI (hoja 1 y 2)</li>
                        <li>Solicitud de inscripción y contrato debidamente completados</li>
                        <li>Certificado de finalización del año inmediato anterior</li>
                        <li>Carné Escolar (Ley Prov. N° 12634/06)</li>
                        <li>2 Fotos 4x4</li>
                        <li>Informe Socioeducativo y/o Legajo del establecimiento donde cursó el año inmediato anterior</li>
                        <li>Fotocopias de las libretas de calificaciones del curso actual y el del inmediato anterior.</li>
                        <li>Grupo Sanguíneo y factor</li>
                        <li>Carné de Vacunación, Certificado bucodental y médico (debe tener fecha de emisión de Marzo del año en que ingrese en adelante)</li>
                        <li>Si concurre a escuela Privada: libre deuda</li>
                        <li>En caso de ingresar a 2º, 3º, 4º o 5º: Certificado de Estudios Incompleto/Pase.</li>
                        <li>Estructura curricular</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- NIVELES -->
    <div class="container" hidden>
        <div class="row">
            <div class="col-lg-4" style="padding:0;">
                <a class="link-seccion" href="#">
                    <section class="seccion-niveles inicial">
                        <div class="col titulo-seccion">
                            <i class="fas fa-paint-brush"></i>
                            <h3>NIVEL INICIAL</h3>
                        </div>
                    </section>
                </a>
            </div>
            <div class="col-lg-4" style="padding:0;">
                <section class="seccion-niveles primario">
                    <div class="col titulo-seccion">
                        <i class="fas fa-pencil-ruler"></i>
                        <h3>NIVEL PRIMARIO</h3>
                    </div>
                </section>
            </div>
            <div class="col-lg-4" style="padding:0;">
                <section class="seccion-niveles secundario">
                    <div class="col titulo-seccion">
                        <i class="fas fa-book"></i>
                        <h3>NIVEL SECUNDARIO</h3>
                    </div>
                </section>
            </div>
        </div>
    </div>

    <!-- CONTACTO -->
    <section class="seccion-contacto">
        <div class="container">
            <div class="row">
                <div class="col titulo-seccion">
                    <i class="far fa-comments"></i>
                    <h3>CONTACTO</h3>
                </div>
            </div>
            <div class="row">
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>DIRECCIÓN</h5>
                        <span>Av. López y Planes 3513</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>TELÉFONO</h5>
                        <span>0342 456 0732</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>E-MAIL</h5>
                        <span>contacto@ipei.edu.ar</span>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3397.0445597627404!2d-60.71727168515121!3d-31.632630313909424!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x95b5a9c953d2b3c9%3A0xa3b052f7bdff0312!2sI.P.E.I.+Instituto+Privado+de+Educaci%C3%B3n+Integral+Leonardo+Da+Vinci!5e0!3m2!1ses-419!2sar!4v1565208836422!5m2!1ses-419!2sar" width="100%" height="250" frameborder="0" style="border:0" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>

    <!-- FOOTER -->
    <footer>
        Technologies for Industry | 2020
    </footer>

    <!-- Modal Juegos Reales -->
    <div class="modal fade" id="modal-juegos-reales" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-chess-rook"></i>
                    <h5 class="modal-title">JUEGOS REALES</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>
                        Los juegos reales nacieron en el año 2004, con la necesidad de integrar a los alumnos del (ex) polimodal y (ex) 8º Y 9º año,
                        pasando por una jornada de juegos, poniendo en práctica los saberes y los talentos de cada uno, favoreciendo así a su respectivo reino.
                        <br><br>
                        A principio de año, el colegio se divide en dos reinos, el Norte o Verde, y el Sur o Negro. Sus respectivos reyes son los encargados de supervisar el orden como así los que arma los equipos para conseguir triunfos en las diferentes actividades.
                        Estos reyes, mediante un sorteo previo, pintan las caras de los nuevos integrantes, como ritual de bautismo.
                        <br><br>
                        Desde su comienzo hubo variados cambios con respecto a las reglas y a las actividades. Fue así que esta jornada fue creciendo poco a poco, mediante el agregado de nuevas actividades, más días de competencia, y hasta con la ambición de contratar árbitros.
                        Pero como todo proyecto se comienza desde lo más pequeño para hacer cosas grandes.
                        <br><br>
                        En este acontecimiento se utilizan los espacios otorgados por el club como lo son el Estadio Cubierto, el Microestadio, la Cancha Auxiliar, el Salón de Patín, el Natatorio, el Playón, como así también el patio de nuestro colegio.

                        <div id="carouselExampleControls" class="carousel slide" data-ride="carousel" style="padding:30px;">
                            <div class="carousel-inner">
                                <?php
                                $ruta = "img/secundaria/juegosreales/"; // Indicar ruta
                                $filehandle = opendir($ruta); // Abrir archivos
                                $i = 0;

                                while ($file = readdir($filehandle)) {
                                    if ($file != "." && $file != "..") {

                                        ?>

                                        <div class="carousel-item <?php if($i==0) echo "active"; ?>">
                                            <img src="<?php echo $ruta.$file; ?>" class="d-block w-100" alt="...">
                                        </div>

                                        <?php

                                        $i++;
                                    }
                                }

                                closedir($filehandle); // Fin lectura archivos
                                ?>
                            </div>
                            <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="sr-only">Previous</span>
                            </a>
                            <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="sr-only">Next</span>
                            </a>
                        </div>

                        Las actividades por las que se compite, están basadas por un tema deferente cada año. Éstas son:
                        <br><br>

                        <ol>
                            <li>
                                Culturales:
                                <ul>
                                    <li>Mural: A partir del tema designado, los alumnos deben plasmarlo en la pared del Playón del club.</li>
                                    <li>Oratoria: disposición oral al público sobre el tema asignado.</li>
                                    <li>Teatro: expresión corporal.</li>
                                    <li>Música: los alumnos muestran sus talentos, con diferentes estilos de música.</li>
                                    <li>Concurso Literario: está dividido en las categorías, cuento, poesía, que son obras inéditas, escritas por el alumno.</li>
                                </ul>
                            </li>
                            <br>
                            <li>
                                Deportivas:
                                <ul>
                                    <li>Futbol 5</li>
                                    <li>Futbol 11</li>
                                    <li>Basket</li>
                                    <li>Voleibol</li>
                                    <li>Handball</li>
                                    <li>Natación</li>
                                    <li>Atletismo</li>
                                </ul>
                            </li>
                            <br>
                            <li>
                                Sociales:
                                <ul>
                                    <li>Ajedrez</li>
                                    <li>Truco</li>
                                    <li>Ping pong</li>
                                </ul>
                            </li>
                        </ol>

                        Éstas últimas tienen sus respectivas reglas. Cada triunfo beneficia a su reino correspondiente.
                        Todas las actividades son calificadas por un jurado dispuesto por la escuela, capacitado para la elección del ganador.
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info horario 1° -->
    <div class="modal fade" id="modal-instancias" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-graduation-cap"></i>
                    <h5 class="modal-title">INSTANCIAS PARA COMPLETAR ESTUDIOS</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <a href="docs\instancias_completar_estudios.docx" type="button" class="btn btn-primary">
                        <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                        <span>Documento Instancias</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="modal-acceso-schoology" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-graduation-cap"></i>
                    <h5 class="modal-title">ACCESO SCHOOLOGY.COM</h5>
                    
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                
                <div class="modal-body">
                    <p>
                        Señores Padres: el día jueves 19 de marzo se les notificará, 
                        a través de los preceptores, el código que les otorgará acceso a la plataforma (schoology.com). 
                        Cada alumno tendrá acceso a su curso y tendrá una comunicación directa con el docente a cargo de 
                        cada espacio curricular. El registro es obligatorio y los trabajos deben ser entregados durante el 
                        período de la cuarentena formando parte de la nota del trimestre.
                        </p>
                    <a href="docs\actividades\GUIA DEL ALUMNO PARA SCHOOLOGY.pdf" type="button" class="btn btn-primary">
                        <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                        <span>Guía de alta a SCHOOLOGY para el alumno</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    
        <div class="modal fade" id="modal-codigo-schoology" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-graduation-cap"></i>
                    <h5 class="modal-title">ACCESO SCHOOLOGY.COM</h5>
                    
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                
                <div class="modal-body">
                    <p>
                       Estimadas familias: Se remiten los códigos de acceso para el ingreso a la plataforma seleccionada, 
                       a fin de desarrollar las actividades escolares en tiempos de cuarentena. Cada estudiante debe ingresar 
                       -SÓLO A SU CURSO- siguiendo el instructivo compartido con anterioridad.
                       Por inquietudes puntuales comunicarse al siguiente correo: escuela.desarrolladores@gmail.com
                       Atte.
                       Equipo Directivo.
                        </p>

                        <a href="docs\actividades\CODIGOS DE LA PLATAFORMA SCHOOLOGY IPEI.pdf" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                            <span>Còdigos Plataforma SCHOOLOGY</span>
                        </a>
                    </div>
            </div>
        </div>
    </div>

    <!-- Modal Info horario 1° -->
    <div class="modal fade" id="modal-info-horario-1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-clock"></i>
                    <h5 class="modal-title">HORARIOS 1° AÑO 2020</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Actualizado al 20/03/2020</p>
                    <img src="img\secundaria\horario 1º.png" alt="" width="100%">
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info horario 2° -->
    <div class="modal fade" id="modal-info-horario-2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-clock"></i>
                    <h5 class="modal-title">HORARIOS 2° AÑO 2020</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Actualizado al 26/03/2020</p>
                    <img src="img\secundaria\horario 2º.png" alt="" width="100%">
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info horario 3° -->
    <div class="modal fade" id="modal-info-horario-3" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-clock"></i>
                    <h5 class="modal-title">HORARIOS 3° AÑO 2020</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Actualizado al 26/03/2020</p>
                    <img src="img\secundaria\horario 3º.png" alt="" width="100%">
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info horario 4° -->
    <div class="modal fade" id="modal-info-horario-4" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-clock"></i>
                    <h5 class="modal-title">HORARIOS 4° AÑO 2020</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Actualizado al 26/03/2020</p>
                    <img src="img\secundaria\horario 4º.png" alt="" width="100%">
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info horario 5° -->
    <div class="modal fade" id="modal-info-horario-5" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-clock"></i>
                    <h5 class="modal-title">HORARIOS 5° AÑO 2020</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Actualizado al 26/03/2020</p>
                    <img src="img\secundaria\horario 5º.png" alt="" width="100%">
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Formularios Docentes -->
    <div class="modal fade" id="formularios-docente" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-folder-open"></i>
                    <h5 class="modal-title">FORMULARIOS DOCENTES</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                            <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                            <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                        </button>
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                            <h7>Solicitud de licencia médica</h7><br>
                            <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                        </button>
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                            <h7>Solicitud de licencias administrativas</h7><br>
                            <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                        </button>
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                            <h7>Solicitud de limitación de licencia administrativa</h7><br>
                            <i class="far fa-file-alt"></i><span>LL-01.pdf</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Formularios Asistentes -->
    <div class="modal fade" id="formularios-asistentes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-folder-open"></i>
                    <h5 class="modal-title">FORMULARIOS ASISTENTES</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                            <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                            <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                        </button>
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                            <h7>Solicitud de licencia médica</h7><br>
                            <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                        </button>
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                            <h7>Solicitud de licencias administrativas</h7><br>
                            <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Vacantes -->
    <div class="modal fade" id="vacantes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-user-plus"></i>
                    <h5 class="modal-title">VACANTES</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                        <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d496d7548121c146c3cc6dd" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d496d7548121c146c3cc6dd')">
                            <i class="far fa-arrow-alt-circle-right"></i>
                            <h7>Nivel INICIAL</h7>
                        </button>
                        <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab31f48121c8016c9c590" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab31f48121c8016c9c590')">
                            <i class="far fa-arrow-alt-circle-right"></i>
                            <h7>Nivel PRIMARIO</h7>
                        </button>
                        <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab3d89aab461714c9c569" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab3d89aab461714c9c569')">
                            <i class="far fa-arrow-alt-circle-right"></i>
                            <h7>Nivel SECUNDARIO</h7>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Inscripción -->
    <div class="modal fade" id="modal-inscripcion" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-exclamation-circle"></i>
                    <h5 class="modal-title">PREINSCRIPCIÓN</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>
                        Se encuentra cerrado el ciclo de preinscripción. Por cualquier consulta, envíe un mail a:
                    </p>
                    <div class="alert alert-primary" role="alert">
                        inscripciones@ipei1291.edu.ar
                    </div>

                </div>
                <!-- <div class="modal-body" hidden>
                <p>Para realizar al inscripciòn al ciclo lectivo 2020 en cualquiera de los niveles se
                debe descargar el siguiente formulario:
            </p>

            <button type="button" class="btn btn-outline-danger">Descargar ficha</button>
            <br><br>
            <p>
            Completarlo y enviarlo al mail:
        </p>
        <div class="alert alert-primary" role="alert">
        inscripciones@ipei1291.edu.ar
    </div>

</div> -->
</div>
</div>
</div>


<script src="js/jquery-3.4.1.js" charset="utf-8"></script>
<script src="./slick/slick.js" type="text/javascript" charset="utf-8"></script>
<script src="js/popper.min.js" charset="utf-8"></script>
<script src="js/bootstrap.min.js" charset="utf-8"></script>
<script src="js/novedades-slider.js" charset="utf-8"></script>
</body>
</html>
