<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/fontawesome/css/all.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick-theme.css">
    <link rel="stylesheet" href="css/slick-edit.css">
    <link rel="stylesheet" href="css/estilos.css">
    
    <link rel="stylesheet" href="css/fonts.css">
    <link rel="stylesheet" href="css/estilos-modal.css">
    <link rel="stylesheet" href="css/seccion-general.css">
    
    <link rel="stylesheet" href="css/media.css">
    <link rel="stylesheet" href="css\simplelightbox.min.css">

    <title>IPEI "Leonardo da Vinci" - Santa Fe</title>
</head>
<body>
    <!-- MENÚ -->
    <nav class="navbar fixed-top navbar-expand-lg navbar-light">
        <div class="container">
      <!-- <a class="navbar-brand" href="#">Navbar</a> -->
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item active">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="institucional.php?i=historia">Historia</a>
                        <!-- <a class="nav-link dropdown-toggle" href="#" id="navbarHistoria" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Institucional <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarHistoria">
                            <a class="dropdown-item" href="institucional.php?i=historia">Historia</a>
                            <a class="dropdown-item" href="institucional.php?i=dossier">Dossier</a>
                        </div> -->
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Docentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-docente">Formularios</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gob.ar/intranetv2')">Intranet Provincial</a>
                            <a class="dropdown-item" href="#" onclick="window.open('http://www.santafe.gov.ar/index.php/educacion/guia/get_tree_by_node?node_id=155232')">Portal Educación</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/index.php/educacion/content/download/251163/1319555/file/Calendario+escolar+2019+webf.pdf')">Calendario Escolar</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/gestioneducativa/#/portal')">Gestión Educativa Santa Fe</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Asistentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <!-- <a class="dropdown-item" href="#">Formularios</a> -->
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-asistentes">Formularios</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Alumnos <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="formulario.php">Preinscripción Ingresantes</a>
                            <!-- <a class="dropdown-item" href="#">Reinscripción</a> -->
                        </div>
                    </li>
                </ul>
                <!-- <form class="form-inline my-2 my-lg-0"> -->
                  <!-- <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"> -->
                  <!--<button class="btn btn-sm btn-primary my-2 my-sm-0" data-toggle="modal" data-target="#vacantes">ENVIÁ TU CV</button>-->
                  <button href="http://www.clubaunion.com.ar/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('http://www.clubaunion.com.ar/')">C.A. UNIÓN</button>
                  <button href="https://ipei.quinttos.com/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('https://ipei.quinttos.com/')">QUINTTOS</button>
                <!-- </form> -->
            </div>
      </div>
    </nav>

    <!-- BANNER -->
    <section class="seccion-banner subseccion">
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="logo-escuela">
                        <img src="img\logo_ipei_blanco.png" alt="">
                        <div class="nombre-escuela">
                            <h1>IPEI</h1>
                            <!-- <h1>Instituto Privado de Educación Integral</h1> -->
                            <h2>LEONARDO DA VINCI</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="" style="background:#3949AB; margin-bottom: 30px;">
        <div class="container">
            <div class="row">
                <div class="col titulo-seccion" style="margin: 20px 0px;">
                    <i class="fas fa-pencil-ruler"></i>
                    <h3>NIVEL PRIMARIO</h3>
                </div>
            </div>
        </div>
    </div>
    
    
    <style>
        .fotos-cuarentena .btn {
            /* background-color: #FF1744 !important; border:none;  */
            border-color: #FF2544;
            border-width: 3px;
            padding: 20px 20px 20px 20px;
        }
        .fotos-cuarentena .btn:hover {
            background-color: #FF2544 !important;
        }
        .fotos-cuarentena i {
            font-size: 25px !important; 
            color: #FF2544 !important;
        }
        .fotos-cuarentena span {
            font-size: 20px !important; 
            color: #FF2544 !important; 
            font-weight: bold;
            position: relative; bottom: 4px;
        }
        .fotos-cuarentena .btn:hover span, .fotos-cuarentena .btn:hover i {
            color: white !important;
        }
        
        @media screen and (max-width: 800px) {
            #btn-sorteo {
                width: 100%;
            }
        }
    </style>
    
    <!--<section class="container mb-4 text-center">
        <a id="acto20deJunio" href="https://www.youtube.com/watch?v=nGFt0ZrR73s&t=186s" target="_blank">
                            <img src="img\Acto20DeJunio.jpg" alt="" style="" width="60%">
        </a>
    </section>-->
    
    <section class="container fotos-cuarentena">
        <div class="row">
            <!-- Actividades -->
            <div class="col-lg-6 mb-3">
                <a href="actividades.php" class="btn btn-outline-danger btn-block">
                    <i class="fas fa-book-reader"></i>
                    <span class="ml-3">ACTIVIDADES</span>
                </a>
            </div>
            <!-- Galería -->
            <div class="col-lg-6 mb-3 galeria-cuarentena">
                <a href="img\cuarentena\20200420_194831.jpg" 
                class="btn btn-outline-danger btn-block">
                    <i class="fas fa-images"></i>
                    <span class="ml-3">LEJOS, PERO CERCA</span>
                </a>

                <?php

                    $txt_links = "img/cuarentena/links_fotos_drive.txt";
                    $link = "";

                    //Leer links de las fotos en drive
                    if(file_exists($txt_links) && ($fpt = fopen($txt_links, "r")) !== false) {

                        while (!feof($fpt)){
                            $link = fgets($fpt);
                            echo '<a href="http://drive.google.com/uc?export=view&id='.$link.'"></a>';
                        }

                        fclose($fpt);
                    }

                ?>

            </div>
        </div>
    </section>
    
    
    <style>
        div.alert a.btn {
            background-color: #FF2544;
            border: none;
            margin-bottom: 10px;
        }
    </style>
     <!-- Nota para los padres -->
        <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">Nota para los padres</h4>
                        <a href="docs/Nota para los padres - 17 de agosto..pdf" type="button" class="btn btn-danger" target="_blank">
                             <i class="fas fa-sign-language" style="color:white;margin-right:10px;"></i>
                            <span> Nota para los padres </span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Dia del Niño -->
        <section class="container mb-4 text-center">
        <a href="docs/FELIZ DIA DEL NINIO.pdf">
            <div class="p-3 rounded-lg" style="color:white;margin-right:10px;">
                <img id="btn-sorteo" class="img-fluid" src="img\banner_felizdiadelninio.png" alt="" width="60%">
            </div>
        </a>
    </section>
    <!-- Ganadores Cumpleaños IPEI -->
        <section class="container mb-4 text-center">
        <a href="cumplesorteo.php">
            <div class="p-3 rounded-lg" style="background: #091e6e">
                <img id="btn-sorteo" class="img-fluid" src="img\felizcumple.jpg" alt="" width="60%">
            </div>
        </a>
    </section>
    
     <!-- Cumpleaños IPEI -->
        <section class="container mb-4 text-center">
        <a href="docs/Ganadores del sorteo por los 34 anios del cumpleanios de la escuela primaria.pdf">
            <div class="p-3 rounded-lg" style="background: #091e6e">
                <img id="btn-sorteo" class="img-fluid" src="img\ganadorescumple.jpg" alt="" width="60%">
            </div>
        </a>
    </section>
    
    <!-- Gabinete Psicopedagógico -->
    <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">Gabinete Psicopedagógico</h4>
                        <p> NUEVO!! - ¿Cómo hablar con tu hijo sobre la pubertad? 
                        <a href="docs/Como hablar con tu hijo sobre la pubertad.pdf" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-sign-language" style="color:white;margin-right:10px;"></i>
                            <span> La pubertad </span>
                        </a>
                        </p>
                        <p> Indicadores a tener en cuenta cuando nuestros hijos tienen miedo 
                        <a href="https://drive.google.com/open?id=1I95J2NIEkb3-qZtKeZvwAwoaieKjISz1" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-sign-language" style="color:white;margin-right:10px;"></i>
                            <span> El miedo </span>
                        </a>
                        </p>
                        <a href="docs/Aplausos a los padres en cuarentena.pdf" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-sign-language" style="color:white;margin-right:10px;"></i>
                            <span>Aplausos para los padres</span>
                        </a>
                        <a href="docs/ServicioPedagogico.pdf" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Cómo explicar a los niños los motivos del aislamiento</span>
                        </a>
                        <a href="https://drive.google.com/open?id=1lf94kTot6XWb5oZxtSE1NcEXaGsiFQS9" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Hábitos saludables en tiempos de cuarentena</span>
                        </a>
                    </div>
                </div>
            </div>
            
        </div>
    </section>
  
    <!-- Nota del director -->
    <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">Nota para los padres</h4>
                         
                        <a href="https://www.youtube.com/watch?v=nUO9Hf7-3sM&feature=youtu.be" type="button" class="btn btn-danger" target="_blank">
                            <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                            <span>Juntos IPEI</span>
                        </a>
                        <a href="docs/Nota para los padres.pdf"  >
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Nota para los padres del Director</span>
                        </a>
                         <a href="docs\Santa Fe_27 de Julio.pdf" type="button" class="btn btn-danger" target="_blank">
                            <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                            <span>Nota del Equipo Directivo 27/07</span>
                        </a>
                        </br>
                        <p>
                        Recordatorio: para comunicarse con el nivel primario hacerlo usando la siguiente casilla de correo:
                        <strong>direccionprimaria1291@ipei1291.edu.ar</strong>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>      
            
            <!-----------------
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">CÓMO ADJUNTAR DOCUMENTOS</h4>
                        <p> 
                        Para adjuntar un documento a un mail, según lo solicitan algunos docentes, puede seguir el siguiente tutorial:
                        <a href="https://www.youtube.com/embed/Mp4h4B6gCNU" type="button" class="btn btn-danger" target="_blank">
                            <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                            <span>Tutorial</span>
                        </a>
                        </p>
                    </div>
                </div>
            </div>
        
    
    ----------------->
    <br>
    
    <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="titulo-seccion">
                        <i class="fas fa-info-circle"></i>
                        <h3>INFO DE INTERÉS</h3>
                    </div>
                    <div class="list-group destacado">
                        <a href="actividades.php" class="list-group-item list-group-item-action">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades - 6ta Semana</span>
                        </a>
                        <a href="actividades.php" class="list-group-item list-group-item-action">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades - 5ta Semana</span>
                        </a>
                          <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-tm-cs">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades Turno Mañana - 4ta Semana</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-tt-cs">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades Turno Tarde - 4ta Semana</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-tm-ts">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades Turno Mañana - 3ra Semana</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-tt-ts">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades Turno Tarde - 3ra Semana</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-tm-ss">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades Turno Mañana - 2da Semana</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-tt-ss">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades Turno Tarde - 2da Semana</span>
                        </a>
                         <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-tm">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades Turno Mañana - 1ra Semana</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-tt">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades Turno Tarde - 1ra Semana</span>
                        </a>
                        <!-----------------
                          <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-cuadernillos-ministerio">
                            <i class="fas fa-book-reader"></i>
                            <span>Material alternativo provisto por el Ministerio de Educación</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-lectura-para-alumnos-padres">
                            <i class="fas fa-book-reader"></i>
                            <span>Lectura para padres y alumnos</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-aprendiendo">
                            <i class="fas fa-book-reader"></i>
                            <span>Para seguir aprendiendo, jugar y leer</span>
                        </a>
                       
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-info-horario-tmañana">
                            <i class="far fa-clock"></i>
                            <span>Horarios turno MAÑANA - 2020</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-info-horario-ttarde">
                            <i class="far fa-clock"></i>
                            <span>Horarios turno TARDE - 2020</span>
                        </a>
                        --------------------->
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="titulo-seccion">
                        <i class="fas fa-check-square"></i>
                        <h3>¿POR QUÉ ELEGIRNOS?</h3>
                    </div>
                    <div class="card" style="padding: 20px; background: #E3F2FD; color: #0D47A1;">
                    <style>
                        ul.lista-elegirnos {
                        list-style: none; /* Remove default bullets */
                        }

                        ul.lista-elegirnos li::before {
                        content: "\2022";  /* Add content: \2022 is the CSS Code/unicode for a bullet */
                        color: blue; /* Change the color */
                        font-weight: bold; /* If you want it to be bold */
                        display: inline-block; /* Needed to add space between the bullet and the text */
                        width: 1em; /* Also needed for space (tweak if needed) */
                        margin-left: -1em; /* Also needed for space (tweak if needed) */
                        }
                    </style>
                        <ul class="lista-elegirnos">
                            <li>Formación integral de personas.</li>
                            <li>Responsabilidad y compromiso (participación de la escuela en diferentes
                            campañas solidarias organizadas por la Institución, el Club Unión u otras
                            ONG).</li>
                            <li>Interacción con el entorno.</li>
                            <li>Atención personalizada.</li>
                            <li>Permanente actualización pedagógica.</li>
                            <li>Gestión colaborativa.</li>
                            <li>Gabinete Psicopedagógico (Integración, adaptaciones metodológicas y
                            curriculares, entrevistas con padres, profesionales de la salud o
                            Instituciones varias según la necesidad del alumno).</li>
                            <li>Turno mañana:7.40 a 12.00 h (a partir de cuarto grado algunos días
                            deben quedarse hasta las 12.40 para tener las materias extra
                            programáticas).</li>
                            <li>Turno tarde: 13.15 a 17.35 h (a partir de cuarto grado algunos días
                            deben entrar a las 12.35 para tener las materias extra programáticas).</li>
                            <li>Educación Física y Natación (dentro del horario de clases, con
                            profesores especializados en la materia).</li>
                            <li>Sala de Informática, de primero a cuarto se da informática como materia
                            integrada, docente de grado y docente del área específica. A partir de
                            quinto grado se da como materia extracurricular.</li>
                            <li>Idiomas: Italiano de primero a séptimo, a partir de cuarto grado se
                            agrega Inglés.</li>
                            <li>Talleres: Italiano, Inglés, Coro y Cerámica (los mismos se realizan en
                            contra turno dentro del horario de clases).</li>
                            <li>Participación en Ferias de Ciencias, Maratón de Lectura, Santa Fe
                            Juega, Megaconciertos y todo evento que la escuela considere
                            importante para la formación integral de nuestros alumnos.</li>
                            <li>Articulación con el Nivel Inicial y con el Nivel Medio.</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <br><br>

    <section class="container seccion-infonivel">
        <div class="row">
            <div class="col">
                <div class="titulo-seccion">
                    <i class="fas fa-images"></i>
                    <h3>GALERÍA DE EVENTOS</h3>
                </div>
            </div>
        </div>

        <style media="screen">
            div.card h5.card-title {
                color: #3949AB;
            }

            div.card-columns div.card {
                -webkit-box-shadow: 0px 0px 28px -2px rgba(0,0,0,0.1);
                -moz-box-shadow: 0px 0px 28px -2px rgba(0,0,0,0.1);
                box-shadow: 0px 0px 28px -2px rgba(0,0,0,0.1);
            }            
        </style>
        
        <!-- Galería de eventos -->
        <div class="card-columns">

<?php

        $ruta = "img/primaria/"; //Ruta principal
        $dir = opendir($ruta);
        $todos = array(); //Arreglo con todos los nombres de las carpetas de los eventos

        //Recorrer todas las carpetas con eventos
        while($current = readdir($dir)) {
            
            if($current != "." && $current != ".." && is_dir($ruta.$current)) {

                $todos [] = $current; //Después se usa para habilitar el lightbox js
                $subruta = $ruta.$current."/"; //Ruta de las carpetas de los eventos
                $evento = opendir($subruta);
                
                
                $txt_titulo = $subruta."titulo.txt";
                $txt_descripcion = $subruta."descripcion.txt";
                $titulo = "";
                $descripcion = "";

                //Leer título del evento
                if(file_exists($txt_titulo) && ($fpt = fopen($txt_titulo, "r")) !== false) {

                    while (!feof($fpt)){
                        $titulo = fgets($fpt);
                    }

                    fclose($fpt);
                }

                //Leer comentarios del evento
                if(file_exists($txt_descripcion) && ($fpd = fopen($txt_descripcion, "r")) !== false) {

                    while (!feof($fpd)){
                        $descripcion = $descripcion == "" ? fgets($fpd) : $descripcion."<br>".fgets($fpd);
                    }

                    fclose($fpd);
                }
                
                $portada = true; //Para que tome la primer imagen de la carpeta como portada

?>
                            <div class="card <?php echo $current ?>">
<?php

                //Recorrer todas las fotos de un evento
                while($foto = readdir($evento)) {

                    $info = new SplFileInfo($foto);
                    $extension = $info->getExtension();

                    if($foto != "." && $foto != ".." && ($extension == "jpg" || $extension == "JPG" || $extension == "jpeg")) {
                        
                        //Acá armar la carta con la portada y el título
                        if($portada == true) {
?>                              
                                <a href="<?php echo $subruta.$foto ?>">
                                    <img src="<?php echo $subruta.$foto ?>" class="card-img-top" alt="...">
                                </a>
                                <div class="card-body">
                                    <h5 class="card-title"><?php echo $titulo ?></h5>
                                    <p class="card-text"><?php echo $descripcion ?></p>
                                </div>
                                <div class="fotos">
<?php
                        }
                        //Acá cargar todas las fotos
                        else {
?>
                                    <a href="<?php echo $subruta.$foto ?>"></a>
<?php
                        }
                        // echo '<a href="'.$subruta.$foto.'">'.$subruta.$foto.'</a>';
                        $portada = false;
                    }
                } //Termina while de recorrida de fotos
?>
                                </div> <!-- div.fotos -->
                            </div > <!-- div.card -->
<?php
            }
        }

?>

        
            
        </div>
    </section>

    <!-- CONTACTO -->
    <section class="seccion-contacto">
        <div class="container">
            <div class="row">
                <div class="col titulo-seccion">
                    <i class="far fa-comments"></i>
                    <h3>CONTACTO</h3>
                </div>
            </div>
            <div class="row">
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>DIRECCIÓN</h5>
                        <span>Av. López y Planes 3513</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>TELÉFONO</h5>
                        <span>0342 456 0732</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>E-MAIL</h5>
                        <span>direccionprimaria1291@ipei1291.edu.ar</span>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3397.0445597627404!2d-60.71727168515121!3d-31.632630313909424!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x95b5a9c953d2b3c9%3A0xa3b052f7bdff0312!2sI.P.E.I.+Instituto+Privado+de+Educaci%C3%B3n+Integral+Leonardo+Da+Vinci!5e0!3m2!1ses-419!2sar!4v1565208836422!5m2!1ses-419!2sar" width="100%" height="250" frameborder="0" style="border:0" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>

    <!-- FOOTER -->
    <footer>
        Technologies for Industry | 2020
    </footer>

    <style media="screen">
        /* Horarios */
        div.row.info-horarios {
            font-size: 22px;
            padding-bottom: 20px;
        }

        i.icono-ingreso, i.icono-salida {
            font-size: 24px;
            margin-left: 10px;
            margin-right: 10px;
        }
        i.icono-ingreso, i.icono-ingreso-distinto {
            color: blue;
        }
        i.icono-salida, i.icono-salida-distinto {
            color: red;
        }

        i.icono-ingreso-distinto, i.icono-salida-distinto {
            font-size: 18px;
            margin-left: 40px; margin-right: 10px;
        }

        /* Viajes */
        div.row.info-viajes table span.badge.badge-danger {
            margin-right: 10px;
        }
        
        .modal h6 {
            margin-left: 10px;
            color: #1A237E;
        }
    </style>
                <!-- Material alternativo provisto por el Ministerio de Educación -->
    <div class="modal fade" id="modal-cuadernillos-ministerio" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">MATERIAL ALTERNATIVO PROVISTO POR EL MINISTERIO DE EDUCACIÒN</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs/Ministerio/1er Grado.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>1er Grado</span>
                            </a>
                            <a href="docs/Ministerio/2do y 3er Grado.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>2do y 3er Grado</span>
                            </a>
                            <a href="docs/Ministerio/4to y 5to Grado.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>4to y 5to Grado</span>
                            </a>
                            <a href="docs/Ministerio/6to y 7mo Grado.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>6to y 7mo Grado</span>
                            </a>
                            
                         </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
        <!-- Lectura para Padres -->
    <div class="modal fade" id="modal-lectura-para-alumnos-padres" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">LECTURA PARA PADRES Y ALUMNOS</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <h5 class="modal-title">--LECTURA PARA PADRES</h5>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs/LecturaParaPadres/Plaza Irlanda - Eduardo Muslip.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Plaza Irlanda</span>
                            </a>
                            <a href="docs/LecturaParaPadres/Galeano Eduardo - El libro de los abrazos.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>El libro de los abrazos</span>
                            </a>
                            <a href="docs/LecturaParaPadres/Ante la Ley.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Ante la Ley</span>
                            </a>
                            <a href="docs/LecturaParaPadres/Cuentos de Canterbury.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Cuentos de Canterbury</span>
                            </a>
                            <a href="docs/LecturaParaPadres/Dublineses.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Dublineses</span>
                            </a>
                            <a href="docs/LecturaParaPadres/El Capote.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>El Capote</span>
                            </a>
                            <a href="docs/LecturaParaPadres/El viento que arrasa.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>El viento que arrasa</span>
                            </a>
                            <a href="docs/LecturaParaPadres/EL COLLAR DE PERLAS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>El collar de perlas</span>
                            </a>
                            <a href="docs/LecturaParaPadres/El Decamerón.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>El Decamerón</span>
                            </a>
                            <a href="docs/LecturaParaPadres/Formas breves.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Formas breves</span>
                            </a>
                            <a href="docs/LecturaParaPadres/El collar.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>El collar</span>
                            </a>
                            <a href="docs/LecturaParaPadres/Sobremesa.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Sobremesa</span>
                            </a>
                        </div>
                    </div>
                </div>
                <h5 class="modal-title">--LECTURA PARA ALUMNOS</h5>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs/LecturaParaPadres/Cuaderno de Cuentos y Leyendas.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Cuaderno de cuentos y leyendas</span>
                            </a>
                            <a href="docs/LecturaParaPadres/Cuentos de la Selva_Horacio Quiroga.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Cuentos de la Selva</span>
                            </a>
                            <a href="docs/LecturaParaPadres/cuentos folklorico_arg_cuentos de animales_Anónimo.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Cuentos Folklóricos Argentinos</span>
                            </a>
                            <a href="docs/LecturaParaPadres/CUENTOSPARAJUGAR.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Cuentos para Jugar</span>
                            </a>
                            <a href="docs/LecturaParaPadres/CUENTOSPORTELEFONO.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Cuentos por teléfono</span>
                            </a>
                            <a href="docs/LecturaParaAlumnos/ASSA_LaCasaDelAgua_CuentosYCanciones.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>La casa del agua</span>
                            </a>
                            <a href="docs/LecturaParaAlumnos/BrujasPrincesasyPicaros.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Brujas, Princesas y Picaros</span>
                            </a>
                            <a href="docs/LecturaParaAlumnos/La-torre-de-cubos.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>La torre de cubos</span>
                            </a>
                            <a href="docs/LecturaParaAlumnos/un-cuento-puajj.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Un cuento puajj</span>
                            </a>
                        </div>
                    </div>
            </div>
        </div>
    </div>
    <!-- Lectura para Alumnos -->
    <div class="modal fade" id="modal-lectura-para-alumnos" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">LECTURA PARA ALUMNOS</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                
                </div>
            </div>
        </div>
    </div>
    
<!-- Aprendiendo, jugar y leer -->
    <div class="modal fade" id="modal-aprendiendo" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">PARA SEGUIR APRENDIENDO, JUGAR Y LEER</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="https://www.educ.ar/" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>www.educ.ar</span>
                            </a>
                            <a href="https://www.mundoprimaria.com/" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>www.mundoprimaria.com</span>
                            </a>
                            <a href="http://imaginaria.com.ar/" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>imaginaria.com.ar</span>
                            </a>
                            <a href="https://arbolabc.com/" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>arbolabc.com</span>
                            </a>
                            <a href="https://www.educapeques.com/" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>www.educapeques.com</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="modal-actividades-at-qs" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">AMBOS TURNOS - 5TA SEMANA</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <h6 class="">TECNOLOGÍA</h6>
                            <a href="docs\actividades\ambos turnos\1ro_TECNOLOGIA_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Primer Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\2do_TECNOLOGIA_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Segundo Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\3ro_TECNOLOGIA_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Tercer Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\4to_TECNOLOGIA_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Cuarto Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\6to_TECNOLOGIA_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Sexto Grado</span>
                            </a>
                        </div>
                    </div>
                
                    <hr>
                
                    <div class="row">
                        <div class="col-12">
                            <h6 class="">INGLÉS</h6>
                            <a href="docs\actividades\ambos turnos\4to_INGLES_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>4to Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\5to_INGLES_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>5to Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\6to_INGLES_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>6to Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\7mo_INGLES_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>7mo Grado</span>
                            </a>
                           
                        </div>
                    </div>
                
                    <hr>
                
                    <div class="row">
                        <div class="col-12">
                            <h6 class="">EDUCACIÓN FÍSICA</h6>
                            <a href="docs\actividades\ambos turnos\3ro y 6to_EDUCACION FISICA_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>3er y 6to Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\4to 5to y 7mo_EDUCACION FISICA_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>4to, 5to y 7mo Grado</span>
                            </a>
                           
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="row">
                        <div class="col-12">
                            <h6 class="">ITALIANO</h6>
                            <a href="docs\actividades\ambos turnos\3ro_ITALIANO_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>3er Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\4to_ITALIANO_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>4to Grado</span>
                            </a>
                           <a href="docs\actividades\ambos turnos\5to_ITALIANO_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>5to Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\6to_ITALIANO_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>6to Grado</span>
                            </a>
                            <a href="docs\actividades\ambos turnos\7mo_ITALIANO_QS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>7mo Grado</span>
                            </a>
                            <a href="https://drive.google.com/open?id=1aGf5qcRg096WWYtu1AZXwDiUmks3vbMb" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>7mo Grado - Guida galattica al corona virus</span>
                            </a>
                        </div>
                    </div>
                
                </div>
            </div>
        </div>
    </div>
        
<!-- Actividades turno tarde - 1ra semana -->
<div class="modal fade" id="modal-actividades-tt" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO TARDE - Primera Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\ACTIVIDADES DE PLASTICA_De 1ro a 7mo.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1°-7° - Educación Plástica</span>
                            </a>
                            <a href="docs\actividades\turno maniana\ACTIVIDADES DE MUSICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1°-7° - Música</span>
                            </a>
                            <a href="docs\actividades\turno maniana\ACTIVIDADES EDUCACION FISICA 2020.doc" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1°-7° - Educación Física</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to 7mo - ITALIANO_1.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6°-7° - iTALIANO (1)</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to 7mo - ITALIANO_2.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6°-7° - iTALIANO (2)</span>
                            </a>
                            <a href="docs\actividades\bambino_coronavirus.mp4" type="button" class="btn btn-primary" style="margin:10px;" target="_blank">
                                <i class="fas fa-play-circle" style="color:white;margin-right:10px;"></i>
                                <span>3° a 5° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\1ro - LENGUA Y MATEMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Lengua y Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\1ro C - TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno tarde\1ro - VIDEOS PARA VER.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Videos para ver</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\2do TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno tarde\2do - LENGUA Y MATEMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Lengua y Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\2do - ACTIVIDADES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Actividades</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\3er grado - ACTIVIDADES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - ACTIVIDADES</span>
                            </a>
                            <a href="docs\actividades\turno maniana\3ro - ITALIANO.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\4to LENGUA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to MATEMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to C_D - TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Tecnologia</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to. CIENCIAS NATURALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - CIENCIAS SOCIALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - INGLES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - ITALIANO.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\5to LENGUA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to MATEMÁTICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Tecnologia</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5TO DE CIENCIAS SOCIALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to - INGLES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to  - ITALIANO.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to - INFORMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\6to LENGUA Y CIENCIAS SOCIALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Lengua y Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to MATEMATICA.doc" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Tecnologia</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - INGLES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - INFORMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <!-- Actividad modelo -->
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\MATEMATICA SEPTIMO TARDE.doc" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo LENGUA Y CIENCIAS SOCIALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Lengua y Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - INGLES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - INFORMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Informática</span>
                            </a>
                        </div>
                        <!--  -->
                    </div>
                </div>
            </div>
        </div>
    </div>

<!-- Actividades turno tarde - 2da semana -->
<div class="modal fade" id="modal-actividades-tt-ss" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO TARDE - Segunda Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\1ro a 4to - ED FISICA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1°-4° - Educación Física</span>
                            </a>
                            <a href="docs\actividades\turno tarde\3ro y 6to - EDUCACION FISICA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3°y 6°  - Educaciòn Fìsica</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\1ro - ACTIVIDADES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Actividades</span>
                            </a>
                            <a href="docs\actividades\turno tarde\1ro - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Italiano</span>
                            </a>
                      </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\2do - ACTIVIDADES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Actividades</span>
                            </a>
                            <a href="docs\actividades\turno tarde\2do - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\3ro - Actividades_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - ACTIVIDADES</span>
                            </a>
                            <a href="docs\actividades\turno tarde\3ro - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\4to - LENGUA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - CIENCIAS SOCIALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Sociales</span>
                            </a>
                             <a href="docs\actividades\turno tarde\4to - FORM ETICA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Formación ética y ciudadana</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\5to - LENGUA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to - CIENCIAS NATURALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Ciencias Naturales</span>
                            </a>
                           
                            <a href="docs\actividades\turno tarde\5to - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Italiano</span>
                            </a>
                           
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                          <a href="docs\actividades\turno tarde\6to - LENGUA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - CIENCIAS SOCIALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Ciencias Sociales</span>
                            </a>
                           <a href="docs\actividades\turno tarde\6to - CIENCIAS NATURALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Matemática y Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6° - INFORMATICA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\7mo - CIENCIAS NATURALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Matemática y Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - LENGUA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - CIENCIAS SOCIALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Ciencias Sociales</span>
                            </a>
                        </div>
                        <!--  -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Actividades turno tarde - 3ra semana -->
<div class="modal fade" id="modal-actividades-tt-ts" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO TARDE - Tercera Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\1ro a 4to_EDUCACION FISICA.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° a 4°- Educación Física</span>
                            </a>
                            <a href="docs\actividades\turno tarde\1ro - 7mo - EDUCACION ARTISTICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° a 7°- Educación Artística</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to a 7mo - EDUCACION FISICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° a 7°- Educación Física</span>
                            </a>
                        </div>
                    </div>
                 <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\1ro - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno tarde\1ro - ITALIANO_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\2do - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno tarde\2do - ACTIVIDADES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Actividades</span>
                            </a>
                            <a href="docs\actividades\turno tarde\2do - ITALIANO_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\3ro - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno tarde\3ro - ACTIVIDADES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Actividades</span>
                            </a>
                            <a href="docs\actividades\turno tarde\3ro - ITALIANO_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Italiano</span>
                            </a>
                        </div>
                    </div>
                      <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\4to - LENGUA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - CIENCIAS SOCIALES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - CIENCIAS NATURALES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - FEyC_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Formación ética y ciudadana</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - ANEXO TECNOLOGIA.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Anexo Tecnología</span>
                            </a>
                        </div>
                    </div>
                      <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\5to - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to - LENGUA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to - MATEMATICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to - CIENCIAS SOCIALES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Ciencias Sociales</span>
                            </a>
                           
                            <a href="docs\actividades\turno tarde\5° - FEyC  y CS NATURALES_TS .pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Formación ética y Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to - INFORMATICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Informática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to_ITALIANO_TS.PDF" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to_6to_ITALIANO_ANEXO.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Italiano Anexo</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                     
                             <a href="docs\actividades\turno tarde\6to - INFORMATICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Informática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to_ITALIANO_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to_6to_ITALIANO_ANEXO.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Italiano Anexo</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\7mo - INFORMATICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Informática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Inglés</span>
                            </a>
                          <a href="docs\actividades\turno tarde\7mo - TECNOLOGIA_CLASE_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Tecnología - Clase</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - TECNOLOGIA_ACT1_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Tecnología - Act. 1</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Tecnología - Act. 2</span>
                            </a>
                             <a href="docs\actividades\turno maniana\7mo - ITALIANO_TS_1.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Italiano(1)</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - ITALIANO_TS_2.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Italiano (2)</span>
                            </a>
                        </div>
                    </div>   
                    
                </div>
            </div>
        </div>
    </div>
    
<!-- Actividades turno tarde - 4ta semana -->
<div class="modal fade" id="modal-actividades-tt-cs" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO TARDE - Cuarta Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\3ro y 6to_ED FISICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° y 6° - Educación Física</span>
                            </a>
                            
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                           <a href="docs\actividades\turno tarde\4to - ITALIANO_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - INGLES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - MATEMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - LENGUA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to - CIENCIAS NATURALES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Naturales</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\5to - INGLES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Inglés</span>
                            </a>
                           <a href="docs\actividades\turno tarde\5to - MATEMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to - INFORMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\6to - LENGUA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - MATEMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - CIENCIAS SOCIALES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - CIENCIAS NATURALES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - FEyC_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Formación Etica y ciudadana</span>
                            </a>
                             <a href="docs\actividades\turno tarde\6to - INGLES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to - INFORMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <!-- Actividad modelo -->
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\7mo - LENGUA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - MATEMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - CIENCIAS SOCIALES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - CIENCIAS NATURALES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - FEyC_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Formación Etica y ciudadana</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - INGLES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - INGLES_RESPUESTAS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Inglés-Respuestas</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo - INFORMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Informática</span>
                            </a>
                        </div>
                        <!--  -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Actividades turno tarde - 5ta semana -->
    <div class="modal fade" id="modal-actividades-tt-qs" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO TARDE - Quinta Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\1ro_ACTIVIDADES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Actividades</span>
                            </a>
                            <a href="docs\actividades\turno tarde\1ro_ITALIANO_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\2do_ITALIANO_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\3ro_ACTIVIDADES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Actividades</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                           <a href="docs\actividades\turno tarde\4to_FEyC_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Formación ética y ciudadana</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to_LENGUA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno tarde\4to_CIENCIAS NATURALES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Naturales</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\5to_MATEMATICA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\5to_FEyC_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Formación ética y ciudadana</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\6to_MATEMÁTICA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to_CIENCIAS SOCIALES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\6to_FEyC_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Formación Etica y ciudadana</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <!-- Actividad modelo -->
                        <div class="col-12">
                            <a href="docs\actividades\turno tarde\7mo_MATEMÁTICA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo_CIENCIAS SOCIALES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno tarde\7mo_FEyC_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Formación Etica y ciudadana</span>
                            </a>
                            
                        </div>
                        <!--  -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Actividades turno mañana -->
    <div class="modal fade" id="modal-actividades-tm" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO MAÑANA - Primera Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\ACTIVIDADES DE PLASTICA_De 1ro a 7mo.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1°-7° - Educación Plástica</span>
                            </a>
                            <a href="docs\actividades\turno maniana\ACTIVIDADES DE MUSICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1°-7° - Música</span>
                            </a>
                            <a href="docs\actividades\turno maniana\ACTIVIDADES EDUCACION FISICA 2020.doc" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1°-7° - Educación Física</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to 7mo - ITALIANO_1.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6°-7° - iTALIANO (1)</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to 7mo - ITALIANO_2.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6°-7° - iTALIANO (2)</span>
                            </a>
                            <a href="docs\actividades\bambino_coronavirus.mp4" type="button" class="btn btn-primary" style="margin:10px;" target="_blank">
                                <i class="fas fa-play-circle" style="color:white;margin-right:10px;"></i>
                                <span>3° a 5° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\1er Grado - ACTIVIDADES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - ACTIVIDADES</span>
                            </a>
                            <a href="docs\actividades\turno maniana\1er Grado A-C - TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° A - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\Tecnologia 1roB - GUEVARA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° B - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\1ro A-B - ITALIANO. docx.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° A-B - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\2º A Y B - ACTIVIDADES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° A-B- ACTIVIDADES</span>
                            </a>
                            <a href="docs\actividades\turno maniana\2do A y B - ITALIANO.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° A-B- Italiano</span>
                            </a>
                            <a href="docs\actividades\turno maniana\2do A_B TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Tecnología</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                         <div class="col-12">
                            <a href="docs\actividades\turno maniana\3er grado - ACTIVIDADES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - ACTIVIDADES</span>
                            </a>
                            <a href="docs\actividades\turno maniana\3ro A_B TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\3ro - ITALIANO.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\4to A TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° A - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to LENGUA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Lengua</span>
                            </a>
                             <a href="docs\actividades\turno maniana\4to - INGLES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to MATEMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Matemática</span>
                            </a>
                        </div>
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\4to CIENCIAS NATURALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - CIENCIAS SOCIALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Sociales</span>
                            </a>
                            
                            <a href="docs\actividades\turno maniana\4toB TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° B - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - ITALIANO.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\5to CIENCIAS NATURALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Ciencias Naturales</span>
                            </a>
                        
                            <a href="docs\actividades\turno maniana\5to CIENCIAS SOCIALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Ciencias Sociales</span>
                            </a>
                        
                            <a href="docs\actividades\turno maniana\5to grado TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Tecnología</span>
                            </a>
                        </div>
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\5to LENGUA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Lengua</span>
                            </a>
                        
                            <a href="docs\actividades\turno maniana\5TO MATEMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to - INGLES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to  - ITALIANO.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to - INFORMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\6to CIENCIAS NATURALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to MATEMÁTICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - INGLES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - LENGUA Y CIENCIAS SOCIALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Lengua y Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - INFORMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\7mo CIENCIAS NATURALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo MATEMÁTICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - LENGUA Y CIENCIAS SOCIALES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Lengua y Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - TECNOLOGIA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - INGLES.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - INFORMATICA.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Informática</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
<!-- Actividades turno mañana - 2da semana -->
<div class="modal fade" id="modal-actividades-tm-ss" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO MAÑANA - Segunda Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\1ro a 4to - ED FISICA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1°-4° - Educación Física</span>
                            </a>
                            <a href="docs\actividades\turno maniana\3ro y 6to - EDUCACION FISICA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3°y 6°  - Educaciòn Fìsica</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\1ro A y B - ACTIVIDADES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Actividades</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\2do A y B - ACTIVIDADES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Actividades</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\3ro - Actividades_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - ACTIVIDADES</span>
                            </a>
                            <a href="docs\actividades\turno maniana\3ro - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\4to - LENGUA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - CIENCIAS SOCIALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Sociales</span>
                            </a>
                             <a href="docs\actividades\turno maniana\4to - MATEMÁTICA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\5to - LENGUA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to - CIENCIAS NATURALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Ciencias Naturales</span>
                            </a>
                           
                            <a href="docs\actividades\turno maniana\5to -  MATEMATICA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Matemática</span>
                           </a>
                           <a href="docs\actividades\turno maniana\5to - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                          <a href="docs\actividades\turno maniana\6to - LENGUA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - CIENCIAS SOCIALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - MATEMATICA, NATURALES Y FEYC_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Matemàtica, Naturales y FEyC</span>
                            </a>
                             <a href="docs\actividades\turno maniana\6° - INFORMATICA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\7mo - ITALIANO_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - LENGUA_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - CIENCIAS SOCIALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - MATEMATICA Y CIENCIAS NATURALES_SS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Matemàtica y Ciencias Naturales</span>
                            </a>
                        </div>
                        <!--  -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    
<!-- Actividades turno mañana - 3ra semana -->
<div class="modal fade" id="modal-actividades-tm-ts" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO MAÑANA - Tercera Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\1ro a 4to_EDUCACION FISICA.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° a 4°- Educación Física</span>
                            </a>
                             <a href="docs\actividades\turno maniana\1ro - 7mo - EDUCACION ARTISTICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° a 7°- Educación Artística</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to a 7mo - EDUCACION FISICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° a 7°- Educación Física</span>
                            </a>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\1ro - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\1ro - ITALIANO_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\2do - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\2do - ITALIANO_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\3ro - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Tecnología</span>
                            </a>
                        
                            <a href="docs\actividades\turno tarde\3ro - ACTIVIDADES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Actividades</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\4to - CIENCIAS SOCIALES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Sociales</span>
                            </a>
                             <a href="docs\actividades\turno maniana\4to - CIENCIAS NATURALES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - FEyC_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Formación Etica y Ciudadana</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - ANEXO TECNOLOGIA.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Anexo Tecnología</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\5to - CIENCIAS SOCIALES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Ciencias Sociales</span>
                            </a>
                           <a href="docs\actividades\turno tarde\5to - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to - FEyC_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Formación Etica y Ciudadana</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Tecnología</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to - INFORMATICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                     
                             <a href="docs\actividades\turno maniana\6to - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - ITALIANO_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - INFORMATICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Informática</span>
                            </a>
                           <a href="docs\actividades\turno maniana\6to - TECNOLOGIA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Tecnología</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\7mo - INFORMATICA_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Informática</span>
                            </a>
                          <a href="docs\actividades\turno maniana\7mo - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - TECNOLOGIA_CLASE_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Tecnología - Clase</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - TECNOLOGIA_ACT1_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Tecnología - Act. 1</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - INGLES_TS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Tecnología - Act. 2</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - ITALIANO_TS_1.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Italiano(1)</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - ITALIANO_TS_2.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Italiano (2)</span>
                            </a>
                        </div>
                        <!--  -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Actividades turno maniana - 4ta semana -->
<div class="modal fade" id="modal-actividades-tm-cs" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO MAÑANA - Cuarta Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\3ro y 6to_ED FISICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° y 6° - Educación Física</span>
                            </a>
                            
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\1ro_ACTIVIDADES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Actividades</span>
                            </a>
                            <a href="docs\actividades\turno maniana\1ro_ITALIANO_CS_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                           <a href="docs\actividades\turno maniana\2do_ACTIVIDADES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Actividades</span>
                            </a>
                            <a href="https://www.youtube.com/watch?v=OdGKb55gArA" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Canciones del Abecedario</span>
                            </a>
                            <a href="https://www.youtube.com/watch?v=ODThScHFBHY" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Patylu - El Abecedario</span>
                            </a>
                             <a href="docs\actividades\turno maniana\2do_ITALIANO_CS_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Italiano</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                          <a href="docs\actividades\turno maniana\4to_LENGUA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Lengua</span>
                            </a> 
                            <a href="docs\actividades\turno maniana\4to - ITALIANO_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Italiano</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to - INGLES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to_MATEMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Matemática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                           <a href="docs\actividades\turno maniana\5to_LENGUA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to - INGLES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to_MATEMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to_CIENCIAS NATURALES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to - INFORMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                          <a href="docs\actividades\turno maniana\6to - LENGUA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - MATEMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - FEyC_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Educación Etica y Ciudadana</span>
                            </a>  
                            <a href="docs\actividades\turno maniana\6to - INGLES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Inglés</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to - INFORMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Informática</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\7mo - LENGUA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - MATEMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - FEyC_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Educación Etica y Ciudadana</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - INGLES_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Inglés</span>
                            </a>
                             <a href="docs\actividades\turno maniana\7mo - INFORMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Informática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo - INFORMATICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Informática</span>
                            </a>
                        </div>
                        <!--  -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Actividades turno mañana - 5ta semana -->
<div class="modal fade" id="modal-actividades-tm-qs" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES TURNO MAÑANA - Quinta Semana</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\1ro_ACTIVIDADES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>1° - Actividades</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\2do_ACTVIDADES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>2° - Actividades</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\3ro_ACTIVIDADES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>3° - Actividades</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                           <a href="docs\actividades\turno maniana\4to_MATEMATICA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to_CIENCIAS NATURALES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Ciencias Naturales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to_LENGUA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Lengua</span>
                            </a>
                            <a href="docs\actividades\turno maniana\4to_FEyC_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>4° - Formación Etica y Ciudadana</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\5to_MATEMATICA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to_FEyC_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Formación ética y ciudadana</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to_FEyC_REFLEXION_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Formación E y C - Reflexión</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to_CIENCIAS SOCIALES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\5to_LENGUA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>5° - Lengua</span>
                            </a>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\6to_7mo_MATEMÁTICA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\6to_CIENCIAS SOCIALES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>6° - Ciencias Sociales</span>
                            </a>
                            
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <!-- Actividad modelo -->
                        <div class="col-12">
                            <a href="docs\actividades\turno maniana\6to_7mo_MATEMÁTICA_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Matemática</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo_CIENCIAS SOCIALES_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Ciencias Sociales</span>
                            </a>
                            <a href="docs\actividades\turno maniana\7mo_FEyC_QS.pdf" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>7° - Formación Etica y ciudadana</span>
                            </a>
                            
                        </div>
                        <!--  -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info horario turno mañana -->
    <div class="modal fade" id="modal-info-horario-tmañana" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-clock"></i>
                    <h5 class="modal-title">HORARIOS TURNO MAÑANA 2020</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <!-- <div class="row">
                        <div class="col-12">
                            <p>En los documentos adjuntos se encuentran todos los horarios.</p>
                        </div>
                    </div> -->
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\horarios_turno_manana_2020.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>HORARIOS turno mañana 2020</span>
                            </a>
                            <a href="docs\horarios_turno_manana_2020_primaria_por_grado.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>HORARIOS POR GRADO turno mañana 2020</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info horario turno tarde -->
    <div class="modal fade" id="modal-info-horario-ttarde" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-clock"></i>
                    <h5 class="modal-title">HORARIOS TURNO TARDE 2020</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <!-- <div class="row">
                        <div class="col-12">
                            <p>Los horarios se encuentran en el documento adjunto.</p>
                        </div>
                    </div> -->
                    <div class="row">
                        <div class="col-12">
                            <a href="docs\horarios_turno_tarde_2020.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>HORARIOS turno tarde 2020</span>
                            </a>
                            <a href="docs\horarios_turno_tarde_2020_primaria_por_grado.docx" type="button" class="btn btn-primary" style="margin:10px;">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>HORARIOS POR GRADO turno tarde 2020</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info viajes -->
    <div class="modal fade" id="modal-info-viajes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-bus-alt"></i>
                    <h5 class="modal-title">VIAJES EDUCATIVOS Y JORNADAS RECREATIVAS</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row info-viajes">
                        <div class="col">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="20px">Curso</th>
                                        <th>Fecha y Lugar</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary">1°</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">23/08/2019</span>
                                            <span>Granja “Los Juanes” (Santa Rosa de Calchines)</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary">2°</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">01/08/2019</span>
                                            <span>Esperanza</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary">3°</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">21/06/2019</span>
                                            <span>San Carlos</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary">4°</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">07/06/2019</span>
                                            <span>Cayastá</span>
                                            <br><br>
                                            <span class="badge badge-danger">26/06/2019</span>
                                            <span>Museo de nuestra ciudad</span>
                                            <br><br>
                                            <span class="badge badge-danger">02/07/2019</span>
                                            <span>Museo de nuestra ciudad</span>
                                            <br><br>
                                            <span class="badge badge-danger">27/09/2019</span>
                                            <span>5° Megaconcierto de Niños Cantores (Plaza 25 de mayo)</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary">5°</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">04/10/2019</span>
                                            <span>Rosario y San Lorenzo</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary">6°</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">18/10/2019</span>
                                            <span>Entre Ríos</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal Formularios Docentes -->
    <div class="modal fade" id="formularios-docente" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-folder-open"></i>
                    <h5 class="modal-title">FORMULARIOS DOCENTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                          <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                          <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencia médica</h7><br>
                          <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencias administrativas</h7><br>
                          <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de limitación de licencia administrativa</h7><br>
                          <i class="far fa-file-alt"></i><span>LL-01.pdf</span>
                      </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Formularios Asistentes -->
    <div class="modal fade" id="formularios-asistentes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-folder-open"></i>
                    <h5 class="modal-title">FORMULARIOS ASISTENTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                          <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                          <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencia médica</h7><br>
                          <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencias administrativas</h7><br>
                          <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                      </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Vacantes -->
    <div class="modal fade" id="vacantes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-user-plus"></i>
                    <h5 class="modal-title">VACANTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                      <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d496d7548121c146c3cc6dd" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d496d7548121c146c3cc6dd')">
                          <i class="far fa-arrow-alt-circle-right"></i>
                          <h7>Nivel INICIAL</h7>
                      </button>
                      <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab31f48121c8016c9c590" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab31f48121c8016c9c590')">
                          <i class="far fa-arrow-alt-circle-right"></i>
                          <h7>Nivel PRIMARIO</h7>
                      </button>
                      <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab3d89aab461714c9c569" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab3d89aab461714c9c569')">
                          <i class="far fa-arrow-alt-circle-right"></i>
                          <h7>Nivel SECUNDARIO</h7>
                      </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Inscripción -->
    <div class="modal fade" id="modal-inscripcion" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-exclamation-circle"></i>
                    <h5 class="modal-title">PREINSCRIPCIÓN</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <p>
                        Se encuentra cerrado el ciclo de preinscripción. Por cualquier consulta, envíe un mail a:
                    </p>
                    <div class="alert alert-primary" role="alert">
                      inscripciones@ipei1291.edu.ar
                    </div>

                </div>
                <!-- <div class="modal-body" hidden>
                    <p>Para realizar al inscripciòn al ciclo lectivo 2020 en cualquiera de los niveles se
                        debe descargar el siguiente formulario:
                    </p>

                    <button type="button" class="btn btn-outline-danger">Descargar ficha</button>
                    <br><br>
                    <p>
                        Completarlo y enviarlo al mail:
                    </p>
                    <div class="alert alert-primary" role="alert">
                      inscripciones@ipei1291.edu.ar
                    </div>

                </div> -->
            </div>
        </div>
    </div>


    <script src="js/jquery-3.4.1.js" charset="utf-8"></script>
    <script src="./slick/slick.js" type="text/javascript" charset="utf-8"></script>
    <script src="js/popper.min.js" charset="utf-8"></script>
    <script src="js/bootstrap.min.js" charset="utf-8"></script>
   <!-- <script src="js/novedades-slider.js" charset="utf-8"></script> -->

    <script src="js/simple-lightbox.min.js" charset="utf-8"></script>
    <script type="text/javascript">

<?php

        foreach ($todos as $nombrecarpeta) {
?>
        $('.card.<?php echo $nombrecarpeta ?> a').simpleLightbox();
<?php       
        }
?>

        $('.galeria-cuarentena a').simpleLightbox();
    </script>
</body>
</html>
