<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/fontawesome/css/all.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick-theme.css">
    <link rel="stylesheet" href="css/slick-edit.css">
    <link rel="stylesheet" href="css/estilos.css">
    
    <link rel="stylesheet" href="css/fonts.css">
    <link rel="stylesheet" href="css/estilos-modal.css">
    <link rel="stylesheet" href="css/seccion-general.css">
    <link rel="stylesheet" href="css/media.css">
    <link rel="stylesheet" href="css\simplelightbox.min.css">

    <title>IPEI "Leonardo da Vinci" - Santa Fe</title>

    <style media="screen">
        body {
            background-image: url('img/fondo-nivel-inicial_opacidad.jpg');
        }
    </style>
</head>
<body>
    <!-- MENÚ -->
    <nav class="navbar fixed-top navbar-expand-lg navbar-light">
        <div class="container">
      <!-- <a class="navbar-brand" href="#">Navbar</a> -->
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item active">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="institucional.php?i=historia">Historia</a>
                        <!-- <a class="nav-link dropdown-toggle" href="#" id="navbarHistoria" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Institucional <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarHistoria">
                            <a class="dropdown-item" href="institucional.php?i=historia">Historia</a>
                            <a class="dropdown-item" href="institucional.php?i=dossier">Dossier</a>
                        </div> -->
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Docentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-docente">Formularios</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gob.ar/intranetv2')">Intranet Provincial</a>
                            <a class="dropdown-item" href="#" onclick="window.open('http://www.santafe.gov.ar/index.php/educacion/guia/get_tree_by_node?node_id=155232')">Portal Educación</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/index.php/educacion/content/download/251163/1319555/file/Calendario+escolar+2019+webf.pdf')">Calendario Escolar</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/gestioneducativa/#/portal')">Gestión Educativa Santa Fe</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Asistentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <!-- <a class="dropdown-item" href="#">Formularios</a> -->
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-asistentes">Formularios</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Alumnos <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="formulario.php">Preinscripción Ingresantes</a>
                            <!-- <a class="dropdown-item" href="#">Reinscripción</a> -->
                        </div>
                    </li>
                </ul>
                <!-- <form class="form-inline my-2 my-lg-0"> -->
                  <!-- <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"> -->
                  <button class="btn btn-sm btn-primary my-2 my-sm-0" data-toggle="modal" data-target="#vacantes">ENVIÁ TU CV</button>
                  <button href="http://www.clubaunion.com.ar/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('http://www.clubaunion.com.ar/')">C.A. UNIÓN</button>
                  <button href="https://ipei.quinttos.com/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('https://ipei.quinttos.com/')">QUINTTOS</button>
                <!-- </form> -->
            </div>
      </div>
    </nav>

    <!-- BANNER -->
    <section class="seccion-banner subseccion">
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="logo-escuela">
                        <img src="img\logo_ipei_blanco.png" alt="">
                        <div class="nombre-escuela">
                            <h1>IPEI</h1>
                            <!-- <h1>Instituto Privado de Educación Integral</h1> -->
                            <h2>LEONARDO DA VINCI</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="" style="background:#536DFE; margin-bottom: 30px;">
        <div class="container">
            <div class="row">
                <div class="col titulo-seccion" style="margin: 20px 0px;">
                    <i class="fas fa-paint-brush"></i>
                    <h3>NIVEL INICIAL</h3>
                </div>
            </div>
        </div>
    </div>
    
    <section class="container" hidden>
        <div class="row">
            <div class="col-12">
                <div class="alert alert-danger text-center" role="alert" style="background:white;">
                    <h2 style="color:red;font-weight: bold;font-family: Raleway-Black;">¡¡FELICES 113 AÑOS!!</h2>
                    <br>
                    <img class="img-fluid" src="img\inicial\feliz_cumple_jardin.jpeg" alt="" width="300px">
                    <img class="img-fluid" src="img\inicial\feliz_cumple_jardin2.jpeg" alt="" width="600px">
                </div>
            </div>
        </div>
    </section>
       <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">VACACIONES DE INVIERNO</h4>
                        <a href="docs\Nota vacaciones de invierno 2020.pdf" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Nota de la Comunidad Educativa</span>
                        </a>
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
        <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">28 de Mayo: Día de los Jardines Infantes</h4>
                        <p> 
                           <a href="https://drive.google.com/file/d/1rDT7FGxqFXuHd4HLONWtvH9p5cQkLIfU/view?usp=sharing" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Día de los Jardines de Infantes</span>
                           </a>
                           <a href="https://drive.google.com/file/d/10CN0S3qwSuXlTbFpQLCDLvg3fk5uQzOY/view?usp=sharing" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Video</span>
                           </a>
                        </p>
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">Ministerio de Cultura de Santa Fe</h4>
                        <p> Para que lo entiendan chicos, chicas y grandes, Canticuénticos nos enseña a prevenir la progagación del DENGUE.

                        </p>
                        <a href="https://m.facebook.com/SantaFeCultura/videos/902641356864240/?refsrc=https%3A%2F%2Fm.facebook.com%2Fstory.php&_rdr" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>¡A descacharrar!</span>
                        </a>
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
    
        <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">Gabinete Psicopedagógico</h4>
                        
                        <a href="docs/actividades/nivel inicial/Salud psicoemocional.pdf" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Salud psico-emocional</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
     

    <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="titulo-seccion">
                        <i class="fas fa-info-circle"></i>
                        <h3>INFO DE INTERÉS</h3>
                    </div>
                    <div class="list-group destacado">
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-em">
                            <i class="fas fa-book-reader"></i>
                            <span>EDUCACION MUSICAL - Semana 4/5</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-ses">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades semana 27/04</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-cuadernillos-provincia">
                            <i class="fas fa-book-reader"></i>
                            <span>Material alternativo provisto por el Ministerio de Educación de la Provincia</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades-ss">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades semana 20/04</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-cuadernillos-ministerio">
                            <i class="fas fa-book-reader"></i>
                            <span>Material alternativo provisto por el Ministerio de Educación de la Naciòn</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-nuevas-actividades">
                            <i class="fas fa-book-reader"></i>
                            <span>Nuevas Actividades</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-mas-actividades">
                            <i class="fas fa-book-reader"></i>
                            <span>Más Actividades</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-actividades">
                            <i class="fas fa-book-reader"></i>
                            <span>Actividades</span>
                        </a>
                        <a href="#" class="list-group-item list-group-item-action" data-toggle="modal" data-target="#modal-info-horario">
                            <i class="far fa-clock"></i>
                            <span>Horarios - 2020</span>
                        </a>
                        
                    </div>
                </div>

                <style>
                    .card.elegirnos ul {
                        list-style: none;
                    }
                    .card.elegirnos ul li::before {
                        content: "\2022";  /* Add content: \2022 is the CSS Code/unicode for a bullet */
                        color: blue; /* Change the color */
                        font-weight: bold; /* If you want it to be bold */
                        display: inline-block; /* Needed to add space between the bullet and the text */
                        width: 1em; /* Also needed for space (tweak if needed) */
                        margin-left: -1em; /* Also needed for space (tweak if needed) */
                    }
                </style>

                <div class="col-lg-8">
                    <div class="titulo-seccion">
                        <!-- <i class="fas fa-info-circle"></i> -->
                        <h3>¿POR QUÉ ELEGIRNOS?</h3>
                    </div>
                    <div class="card elegirnos" style="border-color:#3F51B5; padding: 15px;">
                        <ul>
                            <li>Seis secciones en ambos turnos a partir de 2 años (2, 3, 4 y 5 años).</li>
                            <li>Gabinete psicopedagógico.</li>
                            <li>Continuidad en los 3 niveles.</li>
                            <li>Extensión Horaria: Turno mañana de 7:40 hs. a 8:25 hs. Turno Tarde: de 16:55 hs. a 17:35 hs.</li>

                            <li>Actividades especiales: música, educación física e italiano (a partir de sala de 2 años).
                                Computación (a partir de sala de 3 años). Natación(a partir de sala de 4 años).
                                Taller de Plástica (solo salas de 5 años). Taller de Arte</li>
                            <li>Actividades extracurriculares: Jornada campamentil en el complejo “La Tatenguita”.</li>
                            <li>Experiencias Directas: Museo Histórico Provincial, Museo Roverano, Viaje de Egresados: Colonia Pujol (sección 5 años), Visitas guiadas al Molino Franchino Fábrica Cultural, La redonda, Esquina Encendida, El Alero.</li>

                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <br><br>

    <section class="container seccion-infonivel">
        <div class="row">
            <div class="col">
                <div class="titulo-seccion">
                    <i class="fas fa-images"></i>
                    <h3>GALERÍA DE EVENTOS</h3>
                </div>
            </div>

        </div>

        <style media="screen">
            #diajardines-niño {
                background-image: url('img/inicial/diajardines-dianino/thumbnail_IMG_1129.jpg');
            }
            #plastica-computacion-italiano {
                background-image: url('img/inicial/plastica-computacion-italiano/8.jpg');
            }
            #escritura-pizarron {
                background-image: url('img/inicial/escritura-pizarron/IMG-20190910-WA0031.jpg');
            }
            #visita-museo {
                background-image: url('img/inicial/visita-museo/thumbnail_IMG_20190514_151107.jpg');
            }
            #clases-natacion {
                background-image: url('img/inicial/clases-natacion/IMG-20190503-WA0010.jpg');
            }
            #biblioteca {
                background-image: url('img/inicial/biblioteca/thumbnail_IMG_0796.jpg');
            }
            #taller-plastica {
                background-image: url('img/inicial/biblioteca/thumbnail_IMG_0796.jpg');
            }
            #code {
                background-image: url('img/inicial/code/IMG-20190913-WA0021.jpg');
            }

            div.row.galeria div.col-lg-6 {
                margin-bottom: 20px;
            }
            div.contenedor-evento {
                height: 300px;
                background-size: cover;
                background-position: center;
            }
                div.contenedor-evento h4 {
                    color: white;
                    background-color: #3949AB;
                    display: inline-block;
                    padding: 5px;
                    margin: 5px;
                }
        </style>

        <div class="row galeria">
            <div class="col-lg-6 galeria_plastica-computacion-italiano">
                <a href="img/inicial/plastica-computacion-italiano/4.jpg">
                    <div id="plastica-computacion-italiano" class="contenedor-evento">
                        <h4>Arte - Computación - Italiano</h4>
                    </div>
                </a>

                <?php
                $ruta = "img/inicial/plastica-computacion-italiano/"; // Indicar ruta
                $filehandle = opendir($ruta); // Abrir archivos
                while ($file = readdir($filehandle)) {
                    if ($file != "." && $file != "..") {
                        echo '<a href="'.$ruta.$file.'"></a>';

                    }
                }

                closedir($filehandle); // Fin lectura archivos
                ?>
            </div>

            <div class="col-lg-6 galeria_diajardines-dianino">
                <a href="img\inicial\diajardines-dianino\1.jpg">
                    <div id="diajardines-niño" class="contenedor-evento">
                        <h4>Día de los jardines de infantes. Día del niño</h4>
                    </div>
                </a>
                <?php
                $ruta = "img/inicial/diajardines-dianino/"; // Indicar ruta
                $filehandle = opendir($ruta); // Abrir archivos
                while ($file = readdir($filehandle)) {
                    if ($file != "." && $file != "..") {
                        echo '<a href="'.$ruta.$file.'"></a>';

                    }
                }

                closedir($filehandle); // Fin lectura archivos
                ?>
            </div>

            <div class="col-lg-6 galeria_escritura-pizarron">
                <a href="img/inicial/escritura-pizarron/IMG-20190910-WA0031.jpg">
                    <div id="escritura-pizarron" class="contenedor-evento">
                        <h4>Escritura en pizarrón</h4>
                    </div>
                </a>
                <?php
                $ruta = "img/inicial/escritura-pizarron/"; // Indicar ruta
                $filehandle = opendir($ruta); // Abrir archivos
                while ($file = readdir($filehandle)) {
                    if ($file != "." && $file != "..") {
                        echo '<a href="'.$ruta.$file.'"></a>';

                    }
                }

                closedir($filehandle); // Fin lectura archivos
                ?>
            </div>

            <div class="col-lg-6 galeria_visita-museo">
                <a href="img\inicial\visita-museo\thumbnail_IMG_20190514_151107.jpg">
                    <div id="visita-museo" class="contenedor-evento">
                        <h4>Visita al museo</h4>
                    </div>
                </a>
                <?php
                $ruta = "img/inicial/visita-museo/"; // Indicar ruta
                $filehandle = opendir($ruta); // Abrir archivos
                while ($file = readdir($filehandle)) {
                    if ($file != "." && $file != "..") {
                        echo '<a href="'.$ruta.$file.'"></a>';

                    }
                }

                closedir($filehandle); // Fin lectura archivos
                ?>
            </div>

            <div class="col-lg-6 galeria_clases-natacion">
                <a href="img\inicial\clases-natacion\IMG-20190503-WA0010.jpg">
                    <div id="clases-natacion" class="contenedor-evento">
                        <h4>Clases de natación</h4>
                    </div>
                </a>
                <?php
                $ruta = "img/inicial/clases-natacion/"; // Indicar ruta
                $filehandle = opendir($ruta); // Abrir archivos
                while ($file = readdir($filehandle)) {
                    if ($file != "." && $file != "..") {
                        echo '<a href="'.$ruta.$file.'"></a>';

                    }
                }

                closedir($filehandle); // Fin lectura archivos
                ?>
            </div>

            <div class="col-lg-6 galeria_biblioteca">
                <a href="img\inicial\biblioteca\thumbnail_IMG_0796.jpg">
                    <div id="biblioteca" class="contenedor-evento">
                        <h4>Visita a la Biblioteca Pedagógica y Popular “Domingo F. Sarmiento”</h4>
                    </div>
                </a>
                <?php
                $ruta = "img/inicial/biblioteca/"; // Indicar ruta
                $filehandle = opendir($ruta); // Abrir archivos
                while ($file = readdir($filehandle)) {
                    if ($file != "." && $file != "..") {
                        echo '<a href="'.$ruta.$file.'"></a>';

                    }
                }

                closedir($filehandle); // Fin lectura archivos
                ?>
            </div>

            <div class="col-lg-6 galeria_taller-plastica">
                <a href="img\inicial\taller-plastica\IMG-20190913-WA0018.jpg">
                    <div id="taller-plastica" class="contenedor-evento">
                        <h4>Taller de plástica - Salas de 5 años</h4>
                    </div>
                </a>
                <?php
                $ruta = "img/inicial/taller-plastica/"; // Indicar ruta
                $filehandle = opendir($ruta); // Abrir archivos
                while ($file = readdir($filehandle)) {
                    if ($file != "." && $file != "..") {
                        echo '<a href="'.$ruta.$file.'"></a>';

                    }
                }

                closedir($filehandle); // Fin lectura archivos
                ?>
            </div>

            <div class="col-lg-6 galeria_code">
                <a href="img/inicial/code/IMG-20190913-WA0021.jpg">
                    <div id="code" class="contenedor-evento">
                        <h4>Nos visita el "CODE" - Salas de 5 años</h4>
                    </div>
                </a>
                <?php
                $ruta = "img/inicial/code/"; // Indicar ruta
                $filehandle = opendir($ruta); // Abrir archivos
                while ($file = readdir($filehandle)) {
                    if ($file != "." && $file != "..") {
                        echo '<a href="'.$ruta.$file.'"></a>';

                    }
                }

                closedir($filehandle); // Fin lectura archivos
                ?>
            </div>



        </div>
    </section>

    <br><br>

    <!-- CONTACTO -->
    <section class="seccion-contacto">
        <div class="container">
            <div class="row">
                <div class="col titulo-seccion">
                    <i class="far fa-comments"></i>
                    <h3>CONTACTO</h3>
                </div>
            </div>
            <div class="row">
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>DIRECCIÓN</h5>
                        <span>Av. López y Planes 3513</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>TELÉFONO</h5>
                        <span>0342 456 0732</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>E-MAIL</h5>
                        <span>contacto@ipei.edu.ar</span>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3397.0445597627404!2d-60.71727168515121!3d-31.632630313909424!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x95b5a9c953d2b3c9%3A0xa3b052f7bdff0312!2sI.P.E.I.+Instituto+Privado+de+Educaci%C3%B3n+Integral+Leonardo+Da+Vinci!5e0!3m2!1ses-419!2sar!4v1565208836422!5m2!1ses-419!2sar" width="100%" height="250" frameborder="0" style="border:0" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>

    <!-- FOOTER -->
    <footer>
        Technologies for Industry | 2020
    </footer>

    <style media="screen">
        /* Horarios */
        div.row.info-horarios {
            font-size: 22px;
            padding-bottom: 20px;
            text-align: center;
        }

        i.icono-ingreso, i.icono-salida {
            font-size: 24px;
            margin-left: 10px;
            margin-right: 10px;
        }
        i.icono-ingreso, i.icono-ingreso-distinto {
            color: blue;
        }
        i.icono-salida, i.icono-salida-distinto {
            color: red;
        }

        i.icono-ingreso-distinto, i.icono-salida-distinto {
            font-size: 18px;
            margin-left: 40px; margin-right: 10px;
        }

        /* Viajes */
        div.row.info-viajes table span.badge.badge-danger {
            margin-right: 10px;
        }

        .actividades h5 {
            margin-left: 10px;
            color: #1A237E;
        }
        .actividades p {
            margin-left: 10px;
            margin-right: 10px;
        }

        .actividades .btn {
            color: white;
        }
    </style>
        <!-- Material Educación Musical - 4/5-->
    <div class="modal fade" id="modal-actividades-em" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">EDUCACION MUSICAL - SEMANA 4/5</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <p> 
                        Queridas familias:<br>
Espero que estén muy bien, les envío la propuesta de Música. Esta vez, vamos a jugar a los exploradores, 
con la hermosa canción de Mariana Baggio. El juego es muy simple: vamos explorando la selva y nos escondemos 
cuando se escuchan los sonidos del león y la serpiente. En esta ocasión vamos a explorar la casa, 
buscando elementos para hacer sonidos. Todo lo que les guste, les atraiga y se les ocurra será bienvenido!!. 
Les envío un abrazo grande!!<br>
Seño Victoria.

                        </p>
                        <a href="https://drive.google.com/file/d/14E5u181UzGEKTPWryPrDRGmKv3ZIKu-5/view" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Salita de Mùsica</span>
                        </a>
                        <a href="https://www.youtube.com/watch?v=CB14NLsLeYQ" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Mariana Baggio - Los exploradores</span>
                        </a>
                         </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Material alternativo provisto por el Ministerio de Educación de la Provincia-->
    <div class="modal fade" id="modal-cuadernillos-provincia" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">MATERIAL ALTERNATIVO PROVISTO POR EL MINISTERIO DE EDUCACIÒN DE LA PROVINCIA</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="https://drive.google.com/open?id=1YgOVTArPCHmEu_0rQPphH9qqYNV1EVLj" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>4 y 5 años</span>
                            </a>
                         </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
        <!-- Modal Nuevas Actividades -->
     <div class="modal fade" id="modal-actividades-ses" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES SEMANA 27/4</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body actividades">
                    <div class="row">
                        
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Educación Física</h5>
                            <a href="https://drive.google.com/open?id=1tB2EeFFvCe3tcQOgRrvhK3lJVUus4q6E" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                        </div>
                           
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Informática</h5>
                            <a href="https://drive.google.com/open?id=1IVoYES9WpEbWrGGopuPtD_1F2NzvXUp_" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Sala de 3 años</span>
                            </a>
                            <a href="https://drive.google.com/open?id=1WQKksGYBubD7oYJ5OkH_dfbnRK5s8pko" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Sala de 4 años</span>
                            </a>
                            <a href="https://drive.google.com/open?id=1JXPHO7AN8mCTIfSsgtmD02BeORKNAxXk" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Sala de 5 años</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal Nuevas Actividades -->
     <div class="modal fade" id="modal-actividades-ss" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES SEMANA 20/4</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body actividades">
                    <div class="row">
                        
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Taller de Arte - Salas de 5 años</h5>
                            <a href="docs\actividades\nivel inicial\Sala 5-TALLER DE ARTE_SS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Salas de 5 años</span>
                            </a>
                        </div>
                           
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Italiano - Turno Mañana</h5>
                            <a href="https://www.youtube.com/watch?v=EUtTkxAiTyQ&feature=youtu.be" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Sala de 2 y 3 años</span>
                            </a>
                            <a href="https://www.youtube.com/watch?v=1w0dWTi48E4&feature=youtu.be" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Sala de 4 y 5 años</span>
                            </a>
                            <a href="https://www.youtube.com/watch?v=RHvWW1hYHds&feature=youtu.be" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Impara i colori con gli amici pesciolini</span>
                            </a>
                            <a href="https://www.youtube.com/watch?v=OgBTCehQaiA&feature=youtu.be" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Marty - Il Pappagallo - La TV dei Bambini, Canzoncine per Bambini</span>
                            </a>
                            
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Italiano - Turno Tarde</h5>
                            <a href="docs\actividades\nivel inicial\Sala 2-3-ITALIANO_TT_SS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Sala de 2 y 3 años</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\Sala 4-5-ITALIANO_TT_SS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Sala de 4 y 5 años</span>
                            </a>
                            
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Educaciòn Física</h5>
                            </p>
                            <a href="docs\actividades\nivel inicial\ACTIVIDAD PARA HACER EN CASA.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Actividades para hacer en casa</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
                    <!-- Material alternativo provisto por el Ministerio de Educación -->
    <div class="modal fade" id="modal-cuadernillos-ministerio" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">MATERIAL ALTERNATIVO PROVISTO POR EL MINISTERIO DE EDUCACIÒN</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <a href="https://drive.google.com/open?id=1M_yQQvhitnNSfVsQSeREt2T9_OyaVVfW" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Nota Directivos</span>
                            </a>
                            <a href="https://drive.google.com/open?id=1jY4Cv487F8DV9XEC_lAKj9-8T_yBU6Oi" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>2 y 3 años</span>
                            </a>
                            <a href="https://drive.google.com/open?id=10ESh1tfIddb3FRBE3OEx0cz_onDOnFkv" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>4 y 5 años</span>
                            </a>
                         </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<!-- Modal Nuevas Actividades -->
     <div class="modal fade" id="modal-nuevas-actividades" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">NUEVAS ACTIVIDADES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body actividades">
                    <div class="row">
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Sala de 2 años</h5>
                            <a href="docs\actividades\nivel inicial\Sala_2_ACTIVIDADES_CS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Sala de 3 años</h5>
                            <a href="docs\actividades\nivel inicial\Sala_3_ACTIVIDADES_CS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\Sala_3_INFORMATICA_CS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Informàtica</span>
                            </a>
                            
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Salas de 4 años</h5>
                            <a href="docs\actividades\nivel inicial\Sala_4_ACTIVIDADES_CS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\Sala_4_INFORMATICA_CS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Informàtica</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\Sala_4_5_ITALIANO_CS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Italiano</span>
                            </a>
                            
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Salas de 5 años</h5>
                            <a href="docs\actividades\nivel inicial\Sala_5_ACTIVIDADES_CS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\Sala_5_INFORMATICA_CS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Informàtica</span>
                            </a>
                           
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Arte - Sala 5 años</h5>
                            <a href="docs\actividades\nivel inicial\Sala_5_ARTE_CS.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Educación Física</h5>
                            <a href="docs\actividades\nivel inicial\Sala_3_4_5_EDFISICA_CS.pdf" type="button" class="btn btn-primary" style="margin:10px;" target="_blank">
                                <i class="far fa-file-word" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Italiano - Turno Mañana</h5>
                            <a href="https://youtu.be/_8xNUyDV41o" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Sala de 2 y 3 años</span>
                            </a>
                            <a href="https://youtu.be/RUzHlNvyVPs" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span> Sala de 4 y 5 años</span>
                            </a>
                            <a href="https://youtu.be/bE1RizjHpCQ" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>L'Anatroccolo Occolo Occolo</span>
                            </a>
                             <a href="docs\actividades\nivel inicial\Imagen 1.jpeg" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Imagen 1</span>
                            </a> <a href="docs\actividades\nivel inicial\Imagen 2.jpeg" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Imagen 2</span>
                            </a> <a href="docs\actividades\nivel inicial\Imagen 3.jpeg" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Imagen 3</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Música</h5>
                            </p>
                            <a href="https://www.youtube.com/watch?v=IeqnskE-dpg" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Musicalia - Los instrumentos y sus familias:</span>
                            </a>
                            <a href="http://www.pakapaka.gob.ar/videos/125604" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Son de canción - Tocando juntos</span>
                            </a>
                            <a href="https://www.youtube.com/watch?v=JXgQmzeJISQ" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Toobys - La orquesta</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


     <!-- Modal Actividades -->
     <div class="modal fade" id="modal-mas-actividades" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">MÁS ACTIVIDADES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body actividades">
                    <div class="row">
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Sala de 2 años</h5>
                            <a href="docs\actividades\nivel inicial\pasta de sal.png" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Pasta de sal</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\masa.png" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Masa para modelar</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\pintura comestible.jpeg" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Pintura comestible</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\plastilina.jpeg" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Plastilina</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\literatura 1.png" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Literatura 01</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\literatura.png" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Literatura 02</span>
                            </a>
                            <br>
                            <a href="https://www.youtube.com/embed/-azK67kSZq8" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Mi horrible melena</span>
                            </a>
                            <a href="https://www.youtube.com/embed/k5yDGaaueOU" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Buenas noches Circo</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Salas de 3 años</h5>
                            <a href="docs\actividades\nivel inicial\Juegos y actividades en cuarentena.docx" type="button" class="btn btn-primary" style="margin:10px;" target="_blank">
                                <i class="far fa-file-word" style="color:white;margin-right:10px;"></i>
                                <span>Juegos y Actividades</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Salas de 4 años</h5>
                            <a href="docs\actividades\nivel inicial\actividades cuarentena.docx" type="button" class="btn btn-primary" style="margin:10px;" target="_blank">
                                <i class="far fa-file-word" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Salas de 5 años</h5>
                            <a href="docs\actividades\nivel inicial\salasde5cuarentena.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Gabinete Psicopedagógico</h5>
                            <a href="docs\actividades\nivel inicial\gabinete_psicopedagogico.pptx" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-file-powerpoint" style="color:white;margin-right:10px;"></i>
                                <span>Tiempo de familia</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\Ipei CoronaVirus.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Algunos consejos</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\Cuento Coronavirus para los mas pequenios.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Cuento</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Italiano Turno Mañana</h5>
                            <a href="docs\actividades\nivel inicial\01 Pista 1.mp3" type="button" class="btn btn-success" style="margin:10px;" target="_blank">
                                <i class="fas fa-volume-up" style="color:white;margin-right:10px;"></i>
                                <span>Audio 01</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\03 Pista 3.mp3" type="button" class="btn btn-success" style="margin:10px;" target="_blank">
                                <i class="fas fa-volume-up" style="color:white;margin-right:10px;"></i>
                                <span>Audio 02</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\04 Pista 4.mp3" type="button" class="btn btn-success" style="margin:10px;" target="_blank">
                                <i class="fas fa-volume-up" style="color:white;margin-right:10px;"></i>
                                <span>Audio 03</span>
                            </a>
                            <a href="https://www.youtube.com/embed/_sHspeN2Xms" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Toobys</span>
                            </a>
                            <a href="https://www.youtube.com/embed/O8vgc-7rcMM" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Dino Lingo</span>
                            </a>
                            <br>
                            <a href="docs\actividades\nivel inicial\italiano_inicial_1.jpeg" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Libro 1</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\italiano_inicial_2.jpeg" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Libro 2</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\italiano_inicial_3.jpeg" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Libro 3</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Italiano Turno Tarde</h5>
                            <a href="docs\actividades\nivel inicial\italiano tt documento 24-03-2020.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Libro 1</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\italiano tt salas de 2 y 3.docx" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Salas de 2 y 3 años</span>
                            </a>
                            <a href="docs\actividades\nivel inicial\italiano tt salas 4 y 5.docx" type="button" class="btn btn-warning" style="margin:10px;" target="_blank">
                                <i class="far fa-image" style="color:white;margin-right:10px;"></i>
                                <span>Salas de 4 y 5 años</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Arte - Sala 5 años</h5>
                            <a href="docs\actividades\nivel inicial\ARTE sala 5 anios.pdf" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="far fa-file-pdf" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Educación Física</h5>
                            <a href="docs\actividades\nivel inicial\actividades educacion fisica.docx" type="button" class="btn btn-primary" style="margin:10px;" target="_blank">
                                <i class="far fa-file-word" style="color:white;margin-right:10px;"></i>
                                <span>Actividades</span>
                            </a>
                        </div>
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>Música</h5>
                            <p>
                            Hola queridas familias, 
                            <br>
                            Les envío algunas canciones con juegos para compartir y disfrutar en familia. 
                            Les mando un gran abrazo en estos momentos difíciles para todos, 
                            esperamos pronto poder volver a las actividades regulares del jardín. 
                            Con mucho cariño,
                            <br>
                            Seño Viki.

                            </p>
                            <a href="https://www.youtube.com/embed/GgYVzNBT9VU" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Canticuénticos: Acá tá</span>
                            </a>
                            <a href="https://www.youtube.com/embed/i0AOUp9A6zQ" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>Melocotón Pajarito - Hola ola</span>
                            </a>
                            <br><br>
                            <p>
                            Actividades musicales  para compartir en familia. 
                            <br>
                            Los invitamos  (no es obligatorio) a descargar esta aplicación para poder disfrutar de actividades musicales muy divertidas!! 
                            Es un momento de encuentro musical junto a sus hijos.
                            <br>
                            Nos "seguimos cuidando entre todos". Cariños. Prof. Victoria Gogorza.
                            </p>
                            <a href="https://play.google.com/store/apps/details?id=com.orange.kidspiano.music.songs" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fas fa-globe-americas" style="color:white;margin-right:10px;"></i>
                                <span>Piano Niños Música y Canciones</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Actividades -->
    <div class="modal fade" id="modal-actividades" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-book-reader"></i>
                    <h5 class="modal-title">ACTIVIDADES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12" style="margin-bottom: 30px;">
                            <a href="docs\actividades\nivel inicial\mision_quedarse_en_casa.pdf" type="button" class="btn btn-primary" style="margin:10px;" target="_blank">
                                <i class="fas fa-paperclip" style="color:white;margin-right:10px;"></i>
                                <span>Misión: Quedarse en casa</span>
                            </a>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <a href="https://www.youtube.com/embed/gwH6BMZMcpY" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>La vida sin móvil ni tablet</span>
                            </a>
                            <a href="https://www.youtube.com/embed/Wi2Feru-rp8" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>El túnel</span>
                            </a>
                            <a href="https://www.youtube.com/embed/QiioP7opsNw" type="button" class="btn btn-danger" style="margin:10px;" target="_blank">
                                <i class="fab fa-youtube" style="color:white;margin-right:10px;"></i>
                                <span>El monstruo peludo</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info horario -->
    <div class="modal fade" id="modal-info-horario" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-clock"></i>
                    <h5 class="modal-title">HORARIOS 2020</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row info-horarios">
                        <div class="col-12" style="margin-bottom: 30px;">
                            <h5>TURNO MAÑANA</h5>
                            <i class="fas fa-arrow-right icono-ingreso"></i>
                            <span>Ingreso </span>
                            <span class="badge badge-primary">08.25 h</span>
                            <br>
                            <i class="fas fa-arrow-left icono-salida"></i>
                            <span>Salida </span>
                            <span class="badge badge-danger">11:55 h</span>
                        </div>
                        <div class="col-12">
                            <h5>TURNO TARDE</h5>
                            <i class="fas fa-arrow-right icono-ingreso"></i>
                            <span>Ingreso </span>
                            <span class="badge badge-primary">13:15 h</span>
                            <br>
                            <i class="fas fa-arrow-left icono-salida"></i>
                            <span>Salida </span>
                            <span class="badge badge-danger">16:45 h</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Info viajes -->
    <div class="modal fade" id="modal-info-viajes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-calendar-alt"></i>
                    <h5 class="modal-title">EVENTOS</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="row info-viajes">
                        <div class="col">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Salas</th>
                                        <th>Fecha y Lugar</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary">5 años</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">23/09/2019</span>
                                            <span>Experiencia Educativa-Recreativa  “EDU CAMPO” Country Pujol</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary">2-3-4-5 años</span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">Durante mes de Octubre</span>
                                            <span>Campamentos Educativos - en el Complejo “La Tatenguita”</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary"></span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">18/10/2019</span>
                                            <span>Festejos “Mes de la familia”</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary"></span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">13/11/2019</span>
                                            <span>Fiesta final - Despedimos el año lectivo</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary"></span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">22/11/2019</span>
                                            <span>Festejos “Mes de la Música”</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <span class="badge badge-primary"></span>
                                        </td>
                                        <td>
                                            <span class="badge badge-danger">02/12/2019</span>
                                            <span>Acto Egresados 2019</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal Formularios Docentes -->
    <div class="modal fade" id="formularios-docente" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-folder-open"></i>
                    <h5 class="modal-title">FORMULARIOS DOCENTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                          <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                          <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencia médica</h7><br>
                          <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencias administrativas</h7><br>
                          <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de limitación de licencia administrativa</h7><br>
                          <i class="far fa-file-alt"></i><span>LL-01.pdf</span>
                      </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Formularios Asistentes -->
    <div class="modal fade" id="formularios-asistentes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-folder-open"></i>
                    <h5 class="modal-title">FORMULARIOS ASISTENTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                          <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                          <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencia médica</h7><br>
                          <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                          <h7>Solicitud de licencias administrativas</h7><br>
                          <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                      </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Vacantes -->
    <div class="modal fade" id="vacantes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-user-plus"></i>
                    <h5 class="modal-title">VACANTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                      <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d496d7548121c146c3cc6dd" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d496d7548121c146c3cc6dd')">
                          <i class="far fa-arrow-alt-circle-right"></i>
                          <h7>Nivel INICIAL</h7>
                      </button>
                      <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab31f48121c8016c9c590" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab31f48121c8016c9c590')">
                          <i class="far fa-arrow-alt-circle-right"></i>
                          <h7>Nivel PRIMARIO</h7>
                      </button>
                      <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab3d89aab461714c9c569" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab3d89aab461714c9c569')">
                          <i class="far fa-arrow-alt-circle-right"></i>
                          <h7>Nivel SECUNDARIO</h7>
                      </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Inscripción -->
    <div class="modal fade" id="modal-inscripcion" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-exclamation-circle"></i>
                    <h5 class="modal-title">PREINSCRIPCIÓN</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <p>
                        Se encuentra cerrado el ciclo de preinscripción. Por cualquier consulta, envíe un mail a:
                    </p>
                    <div class="alert alert-primary" role="alert">
                      inscripciones@ipei1291.edu.ar
                    </div>

                </div>
                <!-- <div class="modal-body" hidden>
                    <p>Para realizar al inscripciòn al ciclo lectivo 2020 en cualquiera de los niveles se
                        debe descargar el siguiente formulario:
                    </p>

                    <button type="button" class="btn btn-outline-danger">Descargar ficha</button>
                    <br><br>
                    <p>
                        Completarlo y enviarlo al mail:
                    </p>
                    <div class="alert alert-primary" role="alert">
                      inscripciones@ipei1291.edu.ar
                    </div>

                </div> -->
            </div>
        </div>
    </div>


    <script src="js/jquery-3.4.1.js" charset="utf-8"></script>
    <script src="./slick/slick.js" type="text/javascript" charset="utf-8"></script>
    <script src="js/popper.min.js" charset="utf-8"></script>
    <script src="js/bootstrap.min.js" charset="utf-8"></script>
    <!-- <script src="js/novedades-slider.js" charset="utf-8"></script> -->

    <script src="js/simple-lightbox.min.js" charset="utf-8"></script>
    <script type="text/javascript">
        $('.galeria_plastica-computacion-italiano a').simpleLightbox();
        $('.galeria_diajardines-dianino a').simpleLightbox();
        $('.galeria_escritura-pizarron a').simpleLightbox();
        $('.galeria_visita-museo a').simpleLightbox();
        $('.galeria_clases-natacion a').simpleLightbox();
        $('.galeria_biblioteca a').simpleLightbox();
        $('.galeria_taller-plastica a').simpleLightbox();
        $('.galeria_code a').simpleLightbox();
    </script>
</body>
</html>
