$(document).ready(function(){
    console.log("Novedades slider a");

    $("div.center.slider").slick({
      dots: true,
      infinite: false,
      centerMode: false,
      slidesToShow: 2,
      slidesToScroll: 1,
      arrows: true,
      responsive: [
          {
              breakpoint: 600,
              settings: {
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: false,
              }
          },
          {
              breakpoint: 768,
              settings: {
                  slidesToShow: 2,
                  slidesToScroll: 1,
              }
          },
      ]
    });



    var destacado, novedades;

    $.ajax({
        dataType: 'json',
        url: 'json-novedades.json?_=' + new Date().getTime(),
        success: function (data) {
            console.log(data);
            destacado = data.destacado;
            novedades = data.novedades;
        }
    });

    $('div.destacado a').on('click', function(e){
        e.preventDefault();
    
        var id = parseInt($(this).attr('data-destacado')) - 1;
    
        $('#modal-destacado .seccion-destacado').text(destacado[id].seccion);
        $('#modal-destacado .titulo-destacado').text(destacado[id].titulo);
        $('#modal-destacado .cuerpo-destacado').text(destacado[id].cuerpo);

        if (destacado[id].documento != "") {
            $('#modal-destacado .doc-destacado span').text(destacado[id].doctext);
            $('#modal-destacado .doc-destacado').attr('href', destacado[id].documento);
            $('#modal-destacado .doc-destacado').show();
        }
        else {
            $('#modal-destacado .doc-destacado').hide();
        }
    
        $('#modal-destacado').modal("show");
    
    });

    $('.ver-novedad').on('click', function(e){
        e.preventDefault();
    
        var id = parseInt($(this).attr('data-novedad')) - 1;
    
        console.log(id);
    
        $('#modal-novedad .titulo-novedad').text(novedades[id].titulo);
        $('#modal-novedad .imagen-novedad').attr("src", novedades[id].imagen);
        $('#modal-novedad .cuerpo-novedad').text(novedades[id].cuerpo);
    
        $('#modal-novedad').modal("show");
    
    });
});