<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/fontawesome/css/all.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick-theme.css">
    <link rel="stylesheet" href="css/slick-edit.css">
    <link rel="stylesheet" href="css/estilos.css">
    
    <link rel="stylesheet" href="css/fonts.css">
    <link rel="stylesheet" href="css/estilos-modal.css">
    <link rel="stylesheet" href="css/seccion-general.css">
    <link rel="stylesheet" href="css/media.css">

    <title>IPEI "Leonardo da Vinci" - Santa Fe</title>
</head>
<body>
    <!-- MENÚ -->
    <nav class="navbar fixed-top navbar-expand-lg navbar-light">
        <div class="container">
      <!-- <a class="navbar-brand" href="#">Navbar</a> -->
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item active">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="institucional.php?i=historia">Historia</a>
                        <!-- <a class="nav-link dropdown-toggle" href="#" id="navbarHistoria" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Institucional <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarHistoria">
                            <a class="dropdown-item" href="institucional.php?i=historia">Historia</a>
                            <a class="dropdown-item" href="institucional.php?i=dossier">Dossier</a>
                        </div> -->
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Docentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-docente">Formularios</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gob.ar/intranetv2')">Intranet Provincial</a>
                            <a class="dropdown-item" href="#" onclick="window.open('http://www.santafe.gov.ar/index.php/educacion/guia/get_tree_by_node?node_id=155232')">Portal Educación</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/index.php/educacion/content/download/251163/1319555/file/Calendario+escolar+2019+webf.pdf')">Calendario Escolar</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/gestioneducativa/#/portal')">Gestión Educativa Santa Fe</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Asistentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <!-- <a class="dropdown-item" href="#">Formularios</a> -->
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-asistentes">Formularios</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Alumnos <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="formulario.php">Preinscripción Ingresantes</a>
                            <!-- <a class="dropdown-item" href="#">Reinscripción</a> -->
                        </div>
                    </li>
                </ul>
                <!-- <form class="form-inline my-2 my-lg-0"> -->
                  <!-- <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"> -->
                  <button class="btn btn-sm btn-primary my-2 my-sm-0" data-toggle="modal" data-target="#vacantes">ENVIÁ TU CV</button>
                  <button href="http://www.clubaunion.com.ar/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('http://www.clubaunion.com.ar/')">C.A. UNIÓN</button>
                  <button href="https://ipei.quinttos.com/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('https://ipei.quinttos.com/')">QUINTTOS</button>
                <!-- </form> -->
            </div>
      </div>
    </nav>

        <section class="seccion-banner subseccion">
            <div class="container">
                <div class="row">
                    <div class="col">
                        <div class="logo-escuela">
                            <img src="img\logo_ipei_blanco.png" alt="">
                            <div class="nombre-escuela">
                                <h1>IPEI</h1>
                                <!-- <h1>Instituto Privado de Educación Integral</h1> -->
                                <h2>LEONARDO DA VINCI</h2>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <style media="screen">
            section.seccion-novedades div.card-body {
                background-color:#E8EAF6; color:#1A237E;
            }
                section.seccion-novedades div.card-body h7 {
                    font-family: Raleway-Black; color: #1A237E;
                }
        </style>

        <!-- Dossier -->
        <section class="seccion-novedades" <?php if($_GET["i"]=="historia") echo 'hidden'; ?>>
            <div class="container">
                <div class="row">
                    <div class="col titulo-seccion">
                        <a class="link-seccion" href="#">
                            <i class="fas fa-info-circle"></i>
                            <h3>DOSSIER</h3>
                        </a>
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <span>
                                    Santa Fe, abril 2016
                                </span>
                                <br><br>
                                <p>
                                    El Club Atletico Union de Santa Fe, fundado el 15 de Abril de 1907, desarrolla una amplia gama de actividades deportivas, contando en la actualidad con alrededor de 15.000 socios.
                                    El 24 de Julio del año 2009, asumió una nueva Comisión Directiva del Club, que hasta el día de la fecha se encuentra en función, siendo el Señor Luis Jorge Spahn el Presidente de la misma.
                                    De ésta Comisión Directiva, forma parte , entre otros, el actual Representante Legal, el Dr. C.P.N. Fernando Pallotti, cual fue designado Presidente del Departamento de Actividades Educativas,  y Representante Legal del Instituto Privado de Enseñanza Integral  (I.P.E.I.) "Leonardo da Vinci", de acuerdo con art. 67. g) de los  Estatutos Sociales,   según consta en la nota N°155/09 de agosto de  2009.
                                </p><br>
                                <p>
                                    La nominación del Dr. Pallotti  como Presidente del Instituto, lo ha sido en mérito a su trayectoria profesional, a su vasto “curriculum”, activo dirigente de este Club y de la colectividad italiana y, particularmente del Asociacionismo marchigiano  que  ha   posicionado a dicha  colectividad  en el amplio espectro socio-cultural en toda esta Región  Centro de la República Argentina.

                                    En su gestión estará acompañado por el reconocido profesional, con una aquilatada experiencia en la materia: el Dr. Juan Carlos Hidalgo (ex Rector de la Universidad Nacional del Litoral, y actual Vicepresidente del Departamento de Educación del  C.A.U.
                                    Para vuestro conocimiento le informamos que el Instituto Privado de Enseñanza Integral del (I.P.E.I.) “Leonardo da Vinci” –que funciona en las instalaciones anexas al Club - Avda. Lopez y Planes 3516 de la ciudad de Santa Fe- se inauguró el 5 de mayo de 1986 y constituyó un hecho significativo para la Institución y la ciudad, ubicando al Club Unión  a la vanguardia de sus similares  del interior del país, al incorporar a sus múltiples actividades deportivas y sociales,  la tarea educativa en forma sistemática.

                                Tres son establecimientos integran el Complejo Educativo I.P.E.I:
                                La Escuela Jardín de Infantes Nº 1.369 Nivel Inicial;  la Escuela Nº 1.291 Nivel Primario;  y la Escuela Nº 3.114 Nivel Secundario, las cuales realizan sus actividades escolares en los turnos mañana y tarde.

                                Actualmente posee una matrícula de 997  alumnos,  distribuidos de  la siguiente manera:

                                1) Nivel inicial:           214 alumnos.
                                2) Nivel primario:       477 alumnos.
                                3) Nivel secundario:  421 alumnos, con tres orientaciones: Ciencias Naturales, Humanidades y Ciencias Sociales y Lenguas.

                                En las mismas se utilizan el castellano como primera lengua, e incorporando el aprendizaje de la lengua y la cultura italianas a partir de los cuatro años del Nivel Inicial hasta el quinto año del nivel Secundario inclusive; y además el idioma inglés en el cuarto grado del nivel Primario y en el total del Secundario.

                                Asimismo, para tener una somera noción de  magnitud del Instituto, indicamos que la totalidad del personal docente, no docente y  administrativo asciende a 167 personas.

                                Adjuntamos al presente un sintético “dossier”, confeccionado por sus autoridades, con la reseña de lo que es el Complejo Educativo Instituto Privado de Enseñanza Integral (I.P.E.I.) “Leonardo da Vinci”.
                                </p><br>
                                <p>
                                Sr. Luis Jorge Spahn

                                      Presidente
                                </p><br>
                                <p>
                                Sr. Andrés Monsalvo
                                  Secretario General
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Historia -->
        <section class="seccion-novedades" <?php if($_GET["i"]=="dossier") echo 'hidden'; ?>>
            <div class="container">
                <div class="row">
                    <div class="col titulo-seccion">
                        <a class="link-seccion" href="#">
                            <i class="fas fa-info-circle"></i>
                            <h3>HISTORIA</h3>
                        </a>
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <p>
                                    El Instituto Privado de Educación Integral (I.P.E.I.) nace por iniciativa de un grupo de padres y
                                    docentes interesados en un moderno proyecto educativo, el cual encontró apoyo en las autoridades del
                                    Club Atlético Unión, prestigiosa institución deportiva de la ciudad de Santa Fe, fundado el 15 de abril de 1907.<br>

                                    El I.PE.I. se crea teniendo como fundamento el derecho de “enseñar y aprender” que establece explícitamente
                                    el Art. 14 de la Constitución Nacional, ratificado en la Constitución de la Provincia de Sta. Fe en su Art. 11.<br>

                                    Su inauguración se produjo el 5 de mayo de 1986 y constituyó un hecho significativo para la Institución y la ciudad,
                                    ubicando al Club a la vanguardia de las demás instituciones deportivas del interior del país,
                                    al incorporar a sus múltiples actividades, la tarea educativa en forma sistemática.<br>

                                    Tres Establecimientos integran el Complejo Educativo I.P.E.I.:
                                </p>
                                <ol>
                                    <li>La Escuela Jardín de Infantes Nº 1369 – Nivel Inicial,</li>
                                    <li>La Escuela Nº 1291 – Nivel Primario,</li>
                                    <li>La Escuela Nº 3114 – Nivel Secundario,</li>
                                </ol>
                                <p>
                                    realizando sus actividades escolares en los turnos mañana y tarde.<br>

                                    El I.P.E.I. lleva el nombre del artista y científico italiano Leonardo da Vinci, en reconocimiento a su
                                    importante aporte a la ciencia y la cultura y su extraordinaria contribución a la Humanidad.
                                </p>

                                <!-- imágenes  -->

                                <h7>NORMATIVA</h7>
                                <p>
                                    El Instituto encuadra sus actividades en la Ley de Establecimientos de la Enseñanza Privada Nº 6427 de la Provincia de Santa Fe,
                                    sus leyes complementarias y su correspondiente reglamentación, y en la Ley Nacional de Educación Nº 26.206,
                                    la que en el Art. 8vo. establece:<br>

                                    “La educación brindará las oportunidades necesarias para desarrollar y fortalecer la formación integral de las personas a lo
                                    largo de toda la vida y promover en cada educando la capacidad de definir su proyecto de vida,
                                    basado en los valores de libertad, paz, solidaridad, igualdad, respeto a la diversidad, justicia, responsabilidad y bien común.”
                                </p>

                                <h7>PERFIL Y PROPÓSITO</h7>
                                <p>
                                    El Perfil del I.P.E.I. se define a través de sus propósitos, a saber:
                                </p>

                                <ol>
                                    <li>
                                        Asumir y alentar los valores de respeto y aprecio a la dignidad humana,
                                        libertad, justicia, igualdad, democracia, tolerancia, solidaridad y búsqueda de la verdad.
                                    </li>
                                    <li>
                                        Concebir a la persona como un ser humano, y como tal, singular, libre y racional,
                                        con el objeto de perfeccionarlo en sus 4múltiples manifestaciones.
                                        El Instituto entiende que sus alumnos deben buscar y realizar su propio proyecto de vida,
                                        que la comunidad educativa potenciará.
                                    </li>
                                    <li>
                                        Considerar a la educación como un proceso de enseñanza-aprendizaje que permite al alumno adquirir conocimientos y realizarse en plenitud como persona que integra una sociedad democrática y plural.
                                    </li>
                                    <li>
                                        Educar al alumno para capacitarlo en la autoconducción consciente, libre y responsable de su proyecto personal de vida, conforme a las exigencias de su propio ser y de la compleja y cambiante realidad. Para el Instituto la educación y la convivencia se conciben en un marco de tolerancia y respeto mutuo.
                                    </li>
                                    <li>
                                        Definir a la escuela como un lugar de desarrollo integral de los alumnos mediante un encuentro vital con el patrimonio cultural, como una Institución que debe dar una respuesta a las necesidades de la comunidad, predominando en ella el aspecto formativo sobre el informativo
                                    </li>
                                </ol>

                                <p>
                                    En síntesis, la comunidad educativa, integrada por directivos, docentes, padres, alumnos y personal de apoyo, es entendida como una Institución que responde a las necesidades intelectuales y culturales de los alumnos, consciente de la necesaria y enriquecedora interacción que debe existir con el tejido social al cual pertenece.
                                </p>

                                <h7>DESARROLLO DE ACTIVIDADES E IDIOMAS EXRTANJEROS</h7>
                                <p>
                                    El Instituto desarrolla sus actividades en sus tres niveles: Inicial, Primario y Secundario, en los turnos mañana y tarde, utilizando el castellano como primera lengua e incorporando aprendizajes de la lengua y la cultura italiana a partir de los tres años del Nivel Inicial hasta el quinto año del Nivel Secundario inclusive. Se incorpora el Inglés en el cuarto grado del Nivel Primario y en el total del Secundario.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Modal Formularios Docentes -->
        <div class="modal fade" id="formularios-docente" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <i class="far fa-folder-open"></i>
                        <h5 class="modal-title">FORMULARIOS DOCENTES</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                    </div>
                    <div class="modal-body">
                        <div class="list-group">
                          <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                              <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                              <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                          </button>
                          <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                              <h7>Solicitud de licencia médica</h7><br>
                              <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                          </button>
                          <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                              <h7>Solicitud de licencias administrativas</h7><br>
                              <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                          </button>
                          <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                              <h7>Solicitud de limitación de licencia administrativa</h7><br>
                              <i class="far fa-file-alt"></i><span>LL-01.pdf</span>
                          </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Formularios Asistentes -->
        <div class="modal fade" id="formularios-asistentes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <i class="far fa-folder-open"></i>
                        <h5 class="modal-title">FORMULARIOS ASISTENTES</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                    </div>
                    <div class="modal-body">
                        <div class="list-group">
                          <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                              <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                              <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                          </button>
                          <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                              <h7>Solicitud de licencia médica</h7><br>
                              <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                          </button>
                          <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action">
                              <h7>Solicitud de licencias administrativas</h7><br>
                              <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                          </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Inscripción -->
        <div class="modal fade" id="modal-inscripcion" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <i class="fas fa-exclamation-circle"></i>
                        <h5 class="modal-title">PREINSCRIPCIÓN</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                              <span aria-hidden="true">&times;</span>
                            </button>
                    </div>
                    <div class="modal-body">
                        <p>
                            Se encuentra cerrado el ciclo de preinscripción. Por cualquier consulta, envíe un mail a:
                        </p>
                        <div class="alert alert-primary" role="alert">
                          inscripciones@ipei1291.edu.ar
                        </div>

                    </div>
                    <!-- <div class="modal-body" hidden>
                        <p>Para realizar al inscripciòn al ciclo lectivo 2020 en cualquiera de los niveles se
                            debe descargar el siguiente formulario:
                        </p>

                        <button type="button" class="btn btn-outline-danger">Descargar ficha</button>
                        <br><br>
                        <p>
                            Completarlo y enviarlo al mail:
                        </p>
                        <div class="alert alert-primary" role="alert">
                          inscripciones@ipei1291.edu.ar
                        </div>

                    </div> -->
                </div>
            </div>
        </div>


    <script src="js/jquery-3.3.1.slim.min.js" charset="utf-8"></script>
    <script src="./slick/slick.js" type="text/javascript" charset="utf-8"></script>
    <script src="js/popper.min.js" charset="utf-8"></script>
    <script src="js/bootstrap.min.js" charset="utf-8"></script>
</body>
</html>
