<!DOCTYPE html>
<html lang="en" dir="ltr">
<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/fontawesome/css/all.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick.css">
    <link rel="stylesheet" type="text/css" href="./slick/slick-theme.css">
    <link rel="stylesheet" href="css/slick-edit.css">
    <link rel="stylesheet" href="css/estilos.css">
    <link rel="stylesheet" href="css/media.css">
    <link rel="stylesheet" href="css/fonts.css">
    <link rel="stylesheet" href="css/estilos-modal.css">

    <title>IPEI "Leonardo da Vinci" - Santa Fe</title>
</head>
<body>

    <!-- MENÚ -->
    <nav class="navbar fixed-top navbar-expand-lg navbar-light">
        <div class="container">
      <!-- <a class="navbar-brand" href="#">Navbar</a> -->
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item active">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="institucional.php?i=historia">Historia</a>
                        <!-- <a class="nav-link dropdown-toggle" href="#" id="navbarHistoria" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Institucional <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarHistoria">
                            <a class="dropdown-item" href="institucional.php?i=historia">Historia</a>
                            <a class="dropdown-item" href="institucional.php?i=dossier">Dossier</a>
                        </div> -->
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Docentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-docente">Formularios</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gob.ar/intranetv2')">Intranet Provincial</a>
                            <a class="dropdown-item" href="#" onclick="window.open('http://www.santafe.gov.ar/index.php/educacion/guia/get_tree_by_node?node_id=155232')">Portal Educación</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/index.php/educacion/content/download/251163/1319555/file/Calendario+escolar+2019+webf.pdf')">Calendario Escolar</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/gestioneducativa/#/portal')">Gestión Educativa Santa Fe</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Asistentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <!-- <a class="dropdown-item" href="#">Formularios</a> -->
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-asistentes">Formularios</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Alumnos <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="formulario.php">Preinscripción</a>
                            <!-- <a class="dropdown-item" href="#">Reinscripción</a> -->
                        </div>
                    </li>
                </ul>
                <!-- <form class="form-inline my-2 my-lg-0">
                  <button class="btn btn-sm btn-primary my-2 my-sm-0" data-toggle="modal" data-target="#vacantes">ENVIÁ TU CV</button> -->
                  <button href="http://www.clubaunion.com.ar/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('http://www.clubaunion.com.ar/')">C.A. UNIÓN</button>
                  <button href="https://ipei.quinttos.com/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('https://ipei.quinttos.com/')">QUINTTOS</button>
                <!--</form> -->
            </div>
      </div>
    </nav>

    <!-- BANNER -->
    <section class="seccion-banner">
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="logo-escuela">
                        <img src="img\logo_ipei_blanco.png" alt="">
                        <div class="nombre-escuela">
                            <h1>Instituto</h1>
                            <h1>Privado de</h1>
                            <h1>Educación</h1>
                            <h1>Integral</h1>
                            <h2>LEONARDO DA VINCI</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- NIVELES -->
    <div class="container">
        <div class="row">
            <div class="col-lg-4" style="padding:0;">
                <a class="link-seccion" href="nivelinicial.php">
                    <section class="seccion-niveles inicial">
                        <div class="col titulo-seccion">
                            <i class="fas fa-paint-brush"></i>
                            <h3>NIVEL INICIAL</h3>
                        </div>
                    </section>
                </a>
            </div>
            <div class="col-lg-4" style="padding:0;">
                <a class="link-seccion" href="nivelprimario.php">
                <section class="seccion-niveles primario">
                    <div class="col titulo-seccion">
                        <i class="fas fa-pencil-ruler"></i>
                        <h3>NIVEL PRIMARIO</h3>
                    </div>
                </section>
                </a>
            </div>
            <div class="col-lg-4" style="padding:0;">
                <a class="link-seccion" href="nivelsecundario.php">
                <section class="seccion-niveles secundario">
                    <div class="col titulo-seccion">
                        <i class="fas fa-book"></i>
                        <h3>NIVEL SECUNDARIO</h3>
                    </div>
                </section>
                </a>
            </div>
        </div>
    </div>
    
    <br>
            <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">CUMPLEAÑOS IPEI</h4>
                        <a href="https://www.youtube.com/watch?v=xE65uW5OuY0&feature=emb_logo" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>VIDEO INSTITUCIONAL REALIZADO EN 2017</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="seccion-infonivel">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="alert alert-primary" role="alert">
                        <h4 class="alert-heading">INFORMACIÓN DE INTERÉS</h4>
                        <p>Sres. Padres: por cualquier consulta referida a temas administrativos les agradeceríamos 
                        se comuniquen por correo electrónico a: ipeiadmin@fibercorp.com.ar </p>
                        <p>A continuación encontrarán el instructivo para abonar las cuotas las novedades del mes de Mayo.</p>
                        <a href="docs/PagoCuotaAbril.pdf" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Instructivo pago cuota</span>
                        </a>
                        <a href="https://drive.google.com/open?id=1vpaWECrUusUoYje6mIm-NuxxRcxZvReI" type="button" class="btn btn-danger" target="_blank">
                            <i class="fas fa-book-reader" style="color:white;margin-right:10px;"></i>
                            <span>Cuota Mayo</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <br>
    
    <!-- NOVEDADES -->
    <section class="seccion-novedades">
        <div class="container">
            <div class="row">
            </div>
        </div>
        <div class="container">
            <div class="row">
                <!-- Destacado -->
                <div class="col-lg-4">
                    <div class="titulo-seccion">
                        <i class="fas fa-exclamation-circle"></i>
                        <h3>DESTACADO</h3>
                    </div>
                    <!-- <div class="card border-danger text-danger destacado"> -->
                    <div class="list-group destacado">
                        <!-- <ul class="list-group list-group-flush"> -->
                            <?php
                                $string = file_get_contents("json-novedades.json");
                                $json = json_decode($string, true);

                                for ($i=0; $i < count($json["destacado"]); $i++) {
                            ?>
                            <a href="#" class="list-group-item list-group-item-action" data-destacado="<?php echo $json["destacado"][$i]["id"]; ?>">
                            <!-- <a href="#" > -->
                                <!-- <li class="list-group-item"> -->
                                    <div class="row">
                                        <span class="badge badge-primary" style="margin: 0 0 10px 15px;">
                                        <?php echo $json["destacado"][$i]["seccion"]; ?>
                                        </span>
                                    </div>
                                    
                                    <!-- <i class="fas fa-angle-right"></i> -->
                                    <h5 class="card-title d-inline"><?php echo $json["destacado"][$i]["titulo"]; ?></h5>
                                <!-- </li> -->
                            </a>
                            <?php
                                }
                            ?>
                        <!-- </ul> -->
                    </div>
                    <!-- </div> -->
                </div>
                <!-- Novedades -->
                <div class="col-lg-8">
                    <div class="titulo-seccion">
                            <i class="far fa-newspaper"></i>
                            <h3>NOVEDADES</h3>
                    </div>
                    <div class="center slider">
                        <?php
                            $string = file_get_contents("json-novedades.json");
                            $json = json_decode($string, true);

                            for ($i=0; $i < count($json["novedades"]); $i++) {
                        ?>
                        <a class="ver-novedad" href="" data-novedad="<?php echo $json["novedades"][$i]["id"]; ?>">
                            <div class="card">
                                <img class="card-img-top" src="<?php echo $json["novedades"][$i]["portada"]; ?>">
                                <div class="card-body">
                                    <span class="badge badge-danger">
                                        <?php echo $json["novedades"][$i]["seccion"]; ?>
                                    </span>
                                    <h5 class="card-title">
                                        <?php echo $json["novedades"][$i]["titulo"]; ?>
                                    </h5>
                                    <i class="fas fa-arrow-up" style="font-size:10px;"></i><span class="card-subtitle mb-2 text-muted fecha-novedad" style="font-size:12px;">
                                        <?php echo $json["novedades"][$i]["fecha"]; ?>
                                    </span>
                                </div>
                            </div>
                        </a>

                        <?php
                            }
                        ?>
                    </div>
                </div>
            </div>
        </div>


    </section>

    <!-- CONTACTO -->
    <section class="seccion-contacto">
        <div class="container">
            <div class="row">
                <div class="col titulo-seccion">
                    <i class="far fa-comments"></i>
                    <h3>CONTACTO</h3>
                </div>
            </div>
            <div class="row">
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>DIRECCIÓN</h5>
                        <span>Av. López y Planes 3513, SANTA FE</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>TELÉFONO</h5>
                        <span>(0342) 4560732 / 4566710 / 4552605</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>E-MAIL</h5>
                        <span>contacto@ipei.edu.ar</span>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3397.0445597627404!2d-60.71727168515121!3d-31.632630313909424!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x95b5a9c953d2b3c9%3A0xa3b052f7bdff0312!2sI.P.E.I.+Instituto+Privado+de+Educaci%C3%B3n+Integral+Leonardo+Da+Vinci!5e0!3m2!1ses-419!2sar!4v1565208836422!5m2!1ses-419!2sar" width="100%" height="250" frameborder="0" style="border:0" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>

    <!-- FOOTER -->
    <footer>
        Technologies for Industry | 2020
    </footer>

    <!-- Modal Formularios Docentes -->
    <div class="modal fade" id="formularios-docente" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-folder-open"></i>
                    <h5 class="modal-title">FORMULARIOS DOCENTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                          <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                          <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/Formulario LM-01.pdf')">
                          <h7>Solicitud de licencia médica</h7><br>
                          <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/FormularioLA.pdf')">
                          <h7>Solicitud de licencias administrativas</h7><br>
                          <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                      </button>
                      <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/ LL-01 Solicitud de Limitación de Licencia Administrativa.pdf')">
                          <h7>Solicitud de limitación de licencia administrativa</h7><br>
                          <i class="far fa-file-alt"></i><span>LL-01.pdf</span>
                      </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Formularios Asistentes -->
    <div class="modal fade" id="formularios-asistentes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-folder-open"></i>
                    <h5 class="modal-title">FORMULARIOS ASISTENTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/RC-01.pdf')">
                            <h7>Reconocimiento de servicios y computo de antigüedad</h7><br>
                            <i class="far fa-file-alt"></i><span>RC-01.pdf</span>
                        </button>
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/Formulario LM-01.pdf')">
                            <h7>Solicitud de licencia médica</h7><br>
                            <i class="far fa-file-alt"></i><span>LM-01.pdf</span>
                        </button>
                        <button href="pdf/RC-01.pdf" type="button" class="list-group-item list-group-item-action" onclick="window.open('pdf/FormularioLA.pdf')">
                            <h7>Solicitud de licencias administrativas</h7><br>
                            <i class="far fa-file-alt"></i><span>LA-01.pdf</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Vacantes -->
    <div class="modal fade" id="vacantes" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-user-plus"></i>
                    <h5 class="modal-title">VACANTES</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="list-group">
                      <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d496d7548121c146c3cc6dd" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d496d7548121c146c3cc6dd')">
                          <i class="far fa-arrow-alt-circle-right"></i>
                          <h7>Nivel INICIAL</h7>
                      </button>
                      <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab31f48121c8016c9c590" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab31f48121c8016c9c590')">
                          <i class="far fa-arrow-alt-circle-right"></i>
                          <h7>Nivel PRIMARIO</h7>
                      </button>
                      <button href="https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab3d89aab461714c9c569" type="button" class="list-group-item list-group-item-action" onclick="window.open('https://ipeisantafe.hiringroom.com/jobs/get_vacancy/5d4ab3d89aab461714c9c569')">
                          <i class="far fa-arrow-alt-circle-right"></i>
                          <h7>Nivel SECUNDARIO</h7>
                      </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Destacado -->
    <div class="modal fade" id="modal-destacado" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-exclamation-circle"></i>
                    <h5 class="modal-title">DESTACADO</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <h2 class="seccion-destacado badge badge-primary"></h2>
                    <h3 class="titulo-destacado"></h3>
                    <p class="cuerpo-destacado"></p>
                    <br>
                    <a class="doc-destacado btn btn-primary" href="" style="margin-bottom: 20px; display: none;">
                        <i class="fas fa-paperclip"></i>
                        <span style="margin-left: 10px;"></span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Novedad -->
    <div class="modal fade" id="modal-novedad" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="far fa-newspaper"></i>
                    <h5 class="modal-title">NOVEDAD</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <h3 class="titulo-novedad"></h3>

                    <div class="row">
                        <div class="col-lg-5">
                            <div class="contenedor-imagen">
                                <img class="imagen-novedad" src="" alt="">
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <p class="cuerpo-novedad"></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Inscripción -->
    <div class="modal fade" id="modal-inscripcion" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <i class="fas fa-exclamation-circle"></i>
                    <h5 class="modal-title">PREINSCRIPCIÓN</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <p>
                        Se encuentra cerrado el ciclo de preinscripción. Por cualquier consulta, envíe un mail a:
                    </p>
                    <div class="alert alert-primary" role="alert">
                      inscripciones@ipei1291.edu.ar
                    </div>

                </div>
                <!-- <div class="modal-body" hidden>
                    <p>Para realizar al inscripciòn al ciclo lectivo 2020 en cualquiera de los niveles se
                        debe descargar el siguiente formulario:
                    </p>

                    <button type="button" class="btn btn-outline-danger">Descargar ficha</button>
                    <br><br>
                    <p>
                        Completarlo y enviarlo al mail:
                    </p>
                    <div class="alert alert-primary" role="alert">
                      inscripciones@ipei1291.edu.ar
                    </div>

                </div> -->
            </div>
        </div>
    </div>

    <script src="js/jquery-3.4.1.js" charset="utf-8"></script>
    <script src="./slick/slick.js" type="text/javascript" charset="utf-8"></script>
    <script src="js/popper.min.js" charset="utf-8"></script>
    <script src="js/bootstrap.min.js" charset="utf-8"></script>
    <script src="js/novedades-slider.js?v=<?php echo(rand()); ?>" charset="utf-8"></script>

    <script type="text/javascript">
        // var destacado, novedades;
        // console.log("Index");
        
        // $(document).ready(function() {
        //     $.ajax({
        //       dataType: 'json',
        //       url: 'json-novedades.json',
        //       success: function (data) {
        //           console.log(data);
        //           destacado = data.destacado;
        //           novedades = data.novedades;
        //       }
        //     });
        // });

        // $('div.destacado a').on('click', function(e){
        //     e.preventDefault();

        //     var id = parseInt($(this).attr('data-destacado')) - 1;

        //     $('#modal-destacado .titulo-destacado').text(destacado[id].titulo);
        //     $('#modal-destacado .cuerpo-destacado').text(destacado[id].cuerpo);

        //     $('#modal-destacado').modal("show");

        // });

        // $('.ver-novedad').on('click', function(e){
        //     console.log("Llega acá?");
        //     e.preventDefault();

        //     var id = parseInt($(this).attr('data-novedad')) - 1;

        //     console.log(id);

        //     $('#modal-novedad .titulo-novedad').text(novedades[id].titulo);
        //     $('#modal-novedad .imagen-novedad').attr("src", novedades[id].imagen);
        //     $('#modal-novedad .cuerpo-novedad').text(novedades[id].cuerpo);

        //     $('#modal-novedad').modal("show");

        // });


    </script>
</body>
</html>
