<?php

if (isset($_POST["submit"])) {
    $nivel = filter_input(INPUT_POST, 'nivel');
    $sala = filter_input(INPUT_POST, 'sala');
    $turno = filter_input(INPUT_POST, 'turno');

    $nombre = filter_input(INPUT_POST, 'nombre');
    $apellido = filter_input(INPUT_POST, 'apellido');
    $dni = filter_input(INPUT_POST, 'dni');
    $fecha_nac = filter_input(INPUT_POST, 'fecha_nac');
    $direccion = filter_input(INPUT_POST, 'direccion');

    $nombre_padre = filter_input(INPUT_POST, 'nombre_padre');
    $apellido_padre = filter_input(INPUT_POST, 'apellido_padre');
    $dni_padre = filter_input(INPUT_POST, 'dni_padre');
    $mail_padre = filter_input(INPUT_POST, 'mail_padre');
    $telefono_padre = filter_input(INPUT_POST, 'telefono_padre');
    $celular_padre = filter_input(INPUT_POST, 'celular_padre');
    $direccion_padre = filter_input(INPUT_POST, 'direccion_padre');
    $actividad_padre = filter_input(INPUT_POST, 'actividad_padre');

    $nombre_madre = filter_input(INPUT_POST, 'nombre_madre');
    $apellido_madre = filter_input(INPUT_POST, 'apellido_madre');
    $dni_madre = filter_input(INPUT_POST, 'dni_madre');
    $mail_madre = filter_input(INPUT_POST, 'mail_madre');
    $telefono_madre = filter_input(INPUT_POST, 'telefono_madre');
    $celular_madre = filter_input(INPUT_POST, 'celular_madre');
    $direccion_madre = filter_input(INPUT_POST, 'direccion_madre');
    $actividad_madre = filter_input(INPUT_POST, 'actividad_madre');

    $tiene_hermano = filter_input(INPUT_POST, 'tiene_hermano');
    $nivel_hermano = filter_input(INPUT_POST, 'nivel_hermano');
    $sala_hermano = filter_input(INPUT_POST, 'sala_hermano');
    $turno_hermano = filter_input(INPUT_POST, 'turno_hermano');
    $nombre_hermano = filter_input(INPUT_POST, 'nombre_hermano');
    $apellido_hermano = filter_input(INPUT_POST, 'apellido_hermano');
    $dni_hermano = filter_input(INPUT_POST, 'dni_hermano');
    
    $familiar_institucion = filter_input(INPUT_POST, 'familiar_institucion');
}

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/fontawesome/css/all.css">
    <link rel="stylesheet" href="css/tempusdominus-bootstrap-4.min.css">

    <link rel="stylesheet" href="css/estilos.css">

    <link rel="stylesheet" href="css/fonts.css">
    <link rel="stylesheet" href="css/seccion-general.css">

    <link rel="stylesheet" href="css/media.css">

    <title>IPEI "Leonardo da Vinci" - Santa Fe</title>

    <style>
        h5 {
            color: red;
        }

        label {
            color: #1A237E;
        }

        div.alert.alert-danger {
            /* background: #FF9F80; */
            color: #DD2C00;
        }

        ul {
            list-style: none;
        }

        ul i {
            font-size: 12px;
            position: relative;
            bottom: 1px;
        }


        div.radios label {
            background: none;
            color: #0062cc;
        }
    </style>
</head>

<body>
    <!-- MENÚ -->
    <nav class="navbar fixed-top navbar-expand-lg navbar-light">
        <div class="container">
            <!-- <a class="navbar-brand" href="#">Navbar</a> -->
            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto">
                    <li class="nav-item active">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="institucional.php?i=historia">Historia</a>
                        <!-- <a class="nav-link dropdown-toggle" href="#" id="navbarHistoria" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Institucional <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarHistoria">
                            <a class="dropdown-item" href="institucional.php?i=historia">Historia</a>
                            <a class="dropdown-item" href="institucional.php?i=dossier">Dossier</a>
                        </div> -->
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Docentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-docente">Formularios</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gob.ar/intranetv2')">Intranet Provincial</a>
                            <a class="dropdown-item" href="#" onclick="window.open('http://www.santafe.gov.ar/index.php/educacion/guia/get_tree_by_node?node_id=155232')">Portal Educación</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/index.php/educacion/content/download/251163/1319555/file/Calendario+escolar+2019+webf.pdf')">Calendario Escolar</a>
                            <a class="dropdown-item" href="#" onclick="window.open('https://www.santafe.gov.ar/gestioneducativa/#/portal')">Gestión Educativa Santa Fe</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Asistentes <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <!-- <a class="dropdown-item" href="#">Formularios</a> -->
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#formularios-asistentes">Formularios</a>
                        </div>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Alumnos <i class="fas fa-angle-down"></i>
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            <a class="dropdown-item" href="formulario.php">Preinscripción Ingresantes</a>
                            <!-- <a class="dropdown-item" href="#">Reinscripción</a> -->
                        </div>
                    </li>
                </ul>
                <!-- <form class="form-inline my-2 my-lg-0"> -->
                <!-- <input class="form-control mr-sm-2" type="search" placeholder="Search" aria-label="Search"> -->
                <button class="btn btn-sm btn-primary my-2 my-sm-0" data-toggle="modal" data-target="#vacantes">ENVIÁ TU CV</button>
                <button href="http://www.clubaunion.com.ar/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('http://www.clubaunion.com.ar/')">C.A. UNIÓN</button>
                <button href="https://ipei.quinttos.com/" class="btn btn-sm btn-danger my-2 my-sm-0" onclick="window.open('https://ipei.quinttos.com/')">QUINTTOS</button>
                <!-- </form> -->
            </div>
        </div>
    </nav>

    <!-- BANNER -->
    <section class="seccion-banner subseccion">
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="logo-escuela">
                        <img src="img\logo_ipei_blanco.png" alt="">
                        <div class="nombre-escuela">
                            <h1>IPEI</h1>
                            <!-- <h1>Instituto Privado de Educación Integral</h1> -->
                            <h2>LEONARDO DA VINCI</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="" style="background:#3949AB; margin-bottom: 30px;">
        <div class="container">
            <div class="row">
                <div class="col titulo-seccion" style="margin: 20px 0px;">
                    <i class="fas fa-clipboard-list"></i>
                    <h3>PREINSCRIPCIÓN 2021</h3>
                </div>
            </div>
        </div>
    </div>
    
    <section class="container">
        <div class="row">
            <div class="col-lg-8 offset-lg-2">
                <div class="alert alert-primary" role="alert">
                    <h4 class="alert-heading">Atención</h4>
                    <p>
                        El siguiente formulario está destinado para la <strong>preinscripción de ingresantes 2021</strong>.
                    </p>
                </div>
            </div>
        </div>
    </section>
    
    
    <!-- Mensajes de validación -->
    <?php

    if (isset($alumno_incompleto)) {
        if ($alumno_incompleto || ($padre_incompleto && $madre_incompleta) || $hermano_incompleto || $email_incorrecto || $ningun_telefono) {
    ?>

            <div class="container mt-4">
                <div class="row">
                    <div class="col-lg-8 offset-lg-2">
                        <div class="alert alert-danger" role="alert">
                            <ul class="m-0 p-2">
                                <?php
                                if ($alumno_incompleto)
                                    echo "<li><i class='fas fa-times mr-2'></i> Los datos del alumno están incompletos</li>";
                                ?>
                                <?php
                                if ($padre_incompleto && $madre_incompleta)
                                    echo "<li><i class='fas fa-times mr-2'></i> Debe indicar todos los datos de al menos un tutor</li>";
                                ?>
                                <?php
                                if ($tiene_hermano && $hermano_incompleto)
                                    echo "<li><i class='fas fa-times mr-2'></i> Los datos del hermano están incompletos</li>";
                                ?>
                                <?php
                                if ($email_incorrecto)
                                    echo "<li><i class='fas fa-times mr-2'></i> No indicó una casilla de correo válida</li>";
                                ?>
                                <?php
                                if ($ningun_telefono)
                                    echo "<li><i class='fas fa-times mr-2'></i> Debe suministrar al menos un número de teléfono o celular</li>";
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

    <?php
        }
    }
    ?>

    <!-- Formulario -->
    <section class="container mt-4">
        <form action="enviar.php" method="POST" name="contact-form" enctype="multipart/form-data" novalidate>
            <div class="row">
                <div class="col-lg-8 offset-lg-2">
                    <h5>DATOS DEL <strong>ALUMNO</strong></h5>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3 offset-lg-2">
                    <label for="nivel">Nivel</label>
                    <div class="form-group">
                        <div class="btn-group btn-group-toggle radios" data-toggle="buttons">
                            <label class="btn btn-primary <?php if (isset($nivel) && $nivel == 'inicial') echo 'active' ?>">
                                <input type="radio" name="nivel" id="inicial" autocomplete="off" value="inicial" <?php if (isset($nivel) && $nivel == 'inicial') echo 'checked' ?>> Inicial
                            </label>
                            <label class="btn btn-primary <?php if (isset($nivel) && $nivel == 'primario') echo 'active' ?>">
                                <input type="radio" name="nivel" id="primario" autocomplete="off" value="primario" <?php if (isset($nivel) && $nivel == 'primario') echo 'checked' ?>> Primario
                            </label>
                            <label class="btn btn-primary <?php if (isset($nivel) && $nivel == 'secundario') echo 'active' ?>">
                                <input type="radio" name="nivel" id="secundario" autocomplete="off" value="secundario" <?php if (isset($nivel) && $nivel == 'secundario') echo 'checked' ?>> Secundario
                            </label>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-5">
                    <div class="form-group">
                        <label id="grado" for="sala">Sala</label>
                        <select class="custom-select" id="sala" name="sala">
                        </select>
                    </div>
                </div>
                <div class="col-lg-3 col-7">
                    <label for="turno">Turno</label>
                    <div class="form-group">
                        <div class="btn-group btn-group-toggle radios" data-toggle="buttons">
                            <label class="btn btn-primary <?php if (isset($turno) && $turno == 'maniana') echo 'active' ?>">
                                <input type="radio" name="turno" id="maniana" autocomplete="off" value="maniana" <?php if (isset($turno) && $turno == 'maniana') echo 'checked' ?>> Mañana
                            </label>
                            <label class="btn btn-primary <?php if (isset($turno) && $turno == 'tarde') echo 'active' ?>">
                                <input type="radio" name="turno" id="tarde" autocomplete="off" value="tarde" <?php if (isset($turno) && $turno == 'tarde') echo 'checked' ?>> Tarde
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3 offset-lg-2">
                    <div class="form-group">
                        <label for="nombre">Nombre</label>
                        <input class="form-control" id="nombre" name="nombre" type="text" required value="<?php if (isset($nombre)) echo $nombre ?>">
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="form-group">
                        <label for="apellido">Apellido</label>
                        <input class="form-control" id="apellido" name="apellido" type="text" required value="<?php if (isset($apellido)) echo $apellido ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-4">
                    <div class="form-group">
                        <label for="dni">DNI</label>
                        <input class="form-control" id="dni" name="dni" type="text" required value="<?php if (isset($dni)) echo $dni ?>">
                    </div>
                </div>
                <div class="col-lg-3 offset-lg-2 col-8">
                    <label for="direccion">Fecha de nacimiento</label>
                    <div class="form-group">
                        <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                            <input name="fecha_nac" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required placeholder="dd/mm/aaaa" value="<?php if (isset($fecha_nac)) echo $fecha_nac ?>">
                            <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="form-group">
                        <label for="direccion">Dirección</label>
                        <input class="form-control" id="direccion" name="direccion" type="text" value="<?php if (isset($direccion)) echo $direccion ?>">
                    </div>
                </div>
            </div>


            <div class="row mt-4">
                <div class="col-lg-8 offset-lg-2">
                    <h5>DATOS DEL <strong>PADRE</strong></h5>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3 offset-lg-2">
                    <div class="form-group">
                        <label for="nombre_padre">Nombre</label>
                        <input class="form-control" id="nombre_padre" name="nombre_padre" type="text" value="<?php if (isset($nombre_padre)) echo $nombre_padre ?>">
                    </div>
                </div>

                <div class="col-lg-3">
                    <div class="form-group">
                        <label for="apellido_padre">Apellido</label>
                        <input class="form-control" id="apellido_padre" name="apellido_padre" type="text" value="<?php if (isset($apellido_padre)) echo $apellido_padre ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-4">
                    <div class="form-group">
                        <label for="dni_padre">DNI</label>
                        <input class="form-control" id="dni_padre" name="dni_padre" type="text" value="<?php if (isset($dni_padre)) echo $dni_padre ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 offset-lg-2">
                    <div class="form-group">
                        <label for="mail_padre">Mail</label>
                        <input class="form-control" id="mail_padre" name="mail_padre" type="text" value="<?php if (isset($mail_padre)) echo $mail_padre ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-6">
                    <div class="form-group">
                        <label for="telefono_padre">Teléfono fijo</label>
                        <input class="form-control" id="telefono_padre" name="telefono_padre" type="text" value="<?php if (isset($telefono_padre)) echo $telefono_padre ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-6">
                    <div class="form-group">
                        <label for="celular_padre">Celular</label>
                        <input class="form-control" id="celular_padre" name="celular_padre" type="text" value="<?php if (isset($celular_padre)) echo $celular_padre ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 offset-lg-2">
                    <div class="form-group">
                        <label for="direccion_padre">Dirección</label>
                        <input class="form-control" id="direccion_padre" name="direccion_padre" type="text" value="<?php if (isset($direccion_padre)) echo $direccion_padre ?>">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="form-group">
                        <label for="actividad_padre">Actividad que desarrolla</label>
                        <input class="form-control" id="actividad_padre" name="actividad_padre" type="text" value="<?php if (isset($actividad_padre)) echo $actividad_padre ?>">
                    </div>
                </div>
            </div>


            <div class="row mt-4">
                <div class="col-lg-8 offset-lg-2">
                    <h5>DATOS DE LA <strong>MADRE</strong></h5>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3 offset-lg-2">
                    <div class="form-group">
                        <label for="nombre_madre">Nombre</label>
                        <input class="form-control" id="nombre_madre" name="nombre_madre" type="text" value="<?php if (isset($nombre_madre)) echo $nombre_madre ?>">
                    </div>
                </div>

                <div class="col-lg-3">
                    <div class="form-group">
                        <label for="apellido_madre">Apellido</label>
                        <input class="form-control" id="apellido_madre" name="apellido_madre" type="text" value="<?php if (isset($apellido_madre)) echo $apellido_madre ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-4">
                    <div class="form-group">
                        <label for="dni_madre">DNI</label>
                        <input class="form-control" id="dni_madre" name="dni_madre" type="text" value="<?php if (isset($dni_madre)) echo $dni_madre ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 offset-lg-2">
                    <div class="form-group">
                        <label for="mail_madre">Mail</label>
                        <input class="form-control" id="mail_madre" name="mail_madre" type="text" value="<?php if (isset($mail_madre)) echo $mail_madre ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-6">
                    <div class="form-group">
                        <label for="telefono_madre">Teléfono fijo</label>
                        <input class="form-control" id="telefono_madre" name="telefono_madre" type="text" value="<?php if (isset($telefono_madre)) echo $telefono_madre ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-6">
                    <div class="form-group">
                        <label for="celular_madre">Celular</label>
                        <input class="form-control" id="celular_madre" name="celular_madre" type="text" value="<?php if (isset($celular_madre)) echo $celular_madre ?>">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 offset-lg-2">
                    <div class="form-group">
                        <label for="direccion_madre">Dirección</label>
                        <input class="form-control" id="direccion_madre" name="direccion_madre" type="text" value="<?php if (isset($direccion_madre)) echo $direccion_madre ?>">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="form-group">
                        <label for="actividad_madre">Actividad que desarrolla</label>
                        <input class="form-control" id="actividad_madre" name="actividad_madre" type="text" value="<?php if (isset($actividad_madre)) echo $actividad_madre ?>">
                    </div>
                </div>
            </div>


            <div class="row my-4">
                <div class="col-lg-8 offset-lg-2">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" id="familiar_institucion" name="familiar_institucion" <?php if (isset($familiar_institucion) && $familiar_institucion) echo 'checked' ?>>
                        <label class="custom-control-label" for="familiar_institucion">Tiene algún familiar trabajando en la institución</label>
                    </div>
                </div>
            </div>
            
            <div class="row my-4">
                <div class="col-lg-8 offset-lg-2">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" id="tiene_hermano" name="tiene_hermano" <?php if (isset($tiene_hermano) && $tiene_hermano) echo 'checked' ?>>
                        <label class="custom-control-label" for="tiene_hermano">Hermano/a en la institución</label>
                    </div>
                </div>
            </div>
            <div class="row mt-4 hermano">
                <div class="col-lg-8 offset-lg-2">
                    <h5>DATOS DE <strong>HERMANO/A</strong></h5>
                </div>
            </div>
            <div class="row hermano">
                <div class="col-lg-3 offset-lg-2">
                    <label for="nivel_hermano">Nivel</label>
                    <div class="form-group">
                        <div class="btn-group btn-group-toggle radios" data-toggle="buttons">
                            <label class="btn btn-primary <?php if (isset($nivel_hermano) && $nivel_hermano == 'inicial') echo 'active' ?>">
                                <input type="radio" name="nivel_hermano" id="inicial_h" autocomplete="off" value="inicial" <?php if (isset($nivel_hermano) && $nivel_hermano == 'inicial') echo 'checked' ?>> Inicial
                            </label>
                            <label class="btn btn-primary <?php if (isset($nivel_hermano) && $nivel_hermano == 'primario') echo 'active' ?>">
                                <input type="radio" name="nivel_hermano" id="primario_h" autocomplete="off" value="primario" <?php if (isset($nivel_hermano) && $nivel_hermano == 'primario') echo 'checked' ?>> Primario
                            </label>
                            <label class="btn btn-primary <?php if (isset($nivel_hermano) && $nivel_hermano == 'secundario') echo 'active' ?>">
                                <input type="radio" name="nivel_hermano" id="secundario_h" autocomplete="off" value="secundario" <?php if (isset($nivel_hermano) && $nivel_hermano == 'secundario') echo 'checked' ?>> Secundario
                            </label>
                        </div>
                    </div>
                </div>
                <div class="col-lg-2 col-5">
                    <div class="form-group">
                        <label id="grado_hermano" for="sala_hermano">Sala</label>
                        <select class="form-control" id="sala_hermano" name="sala_hermano">
                        </select>
                    </div>
                </div>
                <div class="col-lg-3 col-7">
                    <label for="turno_hermano">Turno</label>
                    <div class="form-group">
                        <div class="btn-group btn-group-toggle radios" data-toggle="buttons">
                            <label class="btn btn-primary <?php if (isset($turno_hermano) && $turno_hermano == 'maniana') echo 'active' ?>">
                                <input type="radio" name="turno_hermano" id="maniana_h" autocomplete="off" value="maniana" <?php if (isset($turno_hermano) && $turno_hermano == 'maniana') echo 'checked' ?>> Mañana
                            </label>
                            <label class="btn btn-primary <?php if (isset($turno_hermano) && $turno_hermano == 'tarde') echo 'active' ?>">
                                <input type="radio" name="turno_hermano" id="tarde_h" autocomplete="off" value="tarde" <?php if (isset($turno_hermano) && $turno_hermano == 'tarde') echo 'checked' ?>> Tarde
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row hermano">
                <div class="col-lg-3 offset-lg-2">
                    <div class="form-group">
                        <label for="nombre_hermano">Nombre</label>
                        <input class="form-control" id="nombre_hermano" name="nombre_hermano" type="text" value="<?php if (isset($nombre_hermano)) echo $nombre_hermano ?>">
                    </div>
                </div>

                <div class="col-lg-3">
                    <div class="form-group">
                        <label for="apellido_hermano">Apellido</label>
                        <input class="form-control" id="apellido_hermano" name="apellido_hermano" type="text" value="<?php if (isset($apellido_hermano)) echo $apellido_hermano ?>">
                    </div>
                </div>
                <div class="col-lg-2 col-4">
                    <div class="form-group">
                        <label for="dni_hermano">DNI</label>
                        <input class="form-control" id="dni_hermano" name="dni_hermano" type="text" value="<?php if (isset($dni_hermano)) echo $dni_hermano ?>">
                    </div>
                </div>
            </div>

            <div class="row mt-5 mb-2">
                <div class="col-lg-8 offset-lg-2">
                    <p>
                        Este formulario será dirigido a la Administración, quien convocará a
                        una entrevista según vacantes disponibles por nivel.
                        Completar dicho formulario no asegura la inscripción.
                    </p>
                </div>
            </div>

            <div class="row my-4">
                <div class="col-lg-8 offset-lg-2">
                    <input class="btn btn-primary btn-block" id="" name="" type="submit">
                </div>
            </div>
        </form>
    </section>

    <!-- CONTACTO -->
    <section class="seccion-contacto">
        <div class="container">
            <div class="row">
                <div class="col titulo-seccion">
                    <i class="far fa-comments"></i>
                    <h3>CONTACTO</h3>
                </div>
            </div>
            <div class="row">
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>DIRECCIÓN</h5>
                        <span>Av. López y Planes 3513</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-phone"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>TELÉFONO</h5>
                        <span>0342 456 0732</span>
                    </div>
                </div>
                <div class="col-lg">
                    <div class="contacto-icono">
                        <i class="fas fa-envelope"></i>
                    </div>
                    <div class="contacto-info">
                        <h5>E-MAIL</h5>
                        <span>ipeiadmin@fibercorp.com.ar</span>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3397.0445597627404!2d-60.71727168515121!3d-31.632630313909424!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x95b5a9c953d2b3c9%3A0xa3b052f7bdff0312!2sI.P.E.I.+Instituto+Privado+de+Educaci%C3%B3n+Integral+Leonardo+Da+Vinci!5e0!3m2!1ses-419!2sar!4v1565208836422!5m2!1ses-419!2sar" width="100%" height="250" frameborder="0" style="border:0" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </section>

    <!-- FOOTER -->
    <footer>
        Technologies for Industry | 2020
    </footer>

    <script src="js/jquery-3.4.1.js" charset="utf-8"></script>
    <script src="js/moment.js"></script>
    <script src="js/locale/es.js"></script>
    <script src="js/popper.min.js" charset="utf-8"></script>
    <script src="js/bootstrap.min.js" charset="utf-8"></script>


    <script src="js/tempusdominus-bootstrap-4.min.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('.hermano').hide();

            <?php
            if (isset($tiene_hermano) && $tiene_hermano) {
                echo "$('.hermano').show();";
            }
            ?>

            adaptarComboNivel(true);
            adaptarComboNivel(false);

            <?php
            if (isset($sala)) {
                echo "seleccionarSala(false, '" . $sala . "');";
            }
            if (isset($sala_hermano)) {
                echo "seleccionarSala(true, '" . $sala_hermano . "');";
            }
            ?>

            $('#datetimepicker1').datetimepicker({
                widgetPositioning: {
                    horizontal: 'auto',
                    vertical: 'bottom'
                },
                sideBySide: true,
                viewMode: "years",
                // locale: moment.local('es'),
                format: 'DD/MM/YYYY',
                // format: 'L',

            });
        });

        $('input[type=radio][name=nivel]').change(function() {
            adaptarComboNivel(false);
        });

        $('input[type=radio][name=nivel_hermano]').change(function() {
            adaptarComboNivel(true);
        });

        function adaptarComboNivel(delHermano) {
            let nivel = delHermano ? $('input[type=radio][name=nivel_hermano]:checked') : $('input[type=radio][name=nivel]:checked');
            let titulo = delHermano ? $('#grado_hermano') : $('#grado');
            let combo = delHermano ? $('#sala_hermano') : $('#sala');

            combo.children().remove();

            switch (nivel.val()) {
                case "inicial":
                    titulo.text('Sala');
                    
                    combo.append('<option value="s2">2 años</option>');
                    combo.append('<option value="s3">3 años</option>');
                    combo.append('<option value="s4">4 años</option>');
                    combo.append('<option value="s5">5 años</option>');
                    break;
                case "primario":
                    titulo.text('Grado');

                    combo.append('<option value="1g">1ro</option>');
                    combo.append('<option value="2g">2do</option>');
                    combo.append('<option value="3g">3ro</option>');
                    combo.append('<option value="4g">4to</option>');
                    combo.append('<option value="5g">5to</option>');
                    combo.append('<option value="6g">6to</option>');
                    combo.append('<option value="7g">7mo</option>');
                    break;
                case "secundario":
                    titulo.text('Año');

                    combo.append('<option value="1a">1ro</option>');
                    combo.append('<option value="2a">2do</option>');
                    combo.append('<option value="3a">3ro</option>');
                    combo.append('<option value="4a">4to</option>');
                    combo.append('<option value="5a">5to</option>');
                    break;
            }
        }

        function seleccionarSala(delHermano, sala) {
            let check = delHermano ? $("select[name=sala_hermano] option[value=" + sala + "]") : $("select[name=sala] option[value=" + sala + "]");
            check.attr('selected', 'selected');
        }

        //$('input[type=checkbox]').change(function() {
        $('#tiene_hermano').change(function() {
            if ($(this).prop('checked')) $('.hermano').show();
            else $('.hermano').hide();
        });
    </script>
</body>

</html>