<?php

/* VALIDACIÓN */
$nivel = filter_input(INPUT_POST, 'nivel');
$sala = filter_input(INPUT_POST, 'sala');
$turno = filter_input(INPUT_POST, 'turno');

$nombre = filter_input(INPUT_POST, 'nombre');
$apellido = filter_input(INPUT_POST, 'apellido');
$dni = filter_input(INPUT_POST, 'dni');
$fecha_nac = filter_input(INPUT_POST, 'fecha_nac');
$direccion = filter_input(INPUT_POST, 'direccion');

$nombre_padre = filter_input(INPUT_POST, 'nombre_padre');
$apellido_padre = filter_input(INPUT_POST, 'apellido_padre');
$dni_padre = filter_input(INPUT_POST, 'dni_padre');
$mail_padre = filter_input(INPUT_POST, 'mail_padre');
$telefono_padre = filter_input(INPUT_POST, 'telefono_padre');
$celular_padre = filter_input(INPUT_POST, 'celular_padre');
$direccion_padre = filter_input(INPUT_POST, 'direccion_padre');
$actividad_padre = filter_input(INPUT_POST, 'actividad_padre');

$nombre_madre = filter_input(INPUT_POST, 'nombre_madre');
$apellido_madre = filter_input(INPUT_POST, 'apellido_madre');
$dni_madre = filter_input(INPUT_POST, 'dni_madre');
$mail_madre = filter_input(INPUT_POST, 'mail_madre');
$telefono_madre = filter_input(INPUT_POST, 'telefono_madre');
$celular_madre = filter_input(INPUT_POST, 'celular_madre');
$direccion_madre = filter_input(INPUT_POST, 'direccion_madre');
$actividad_madre = filter_input(INPUT_POST, 'actividad_madre');

$tiene_hermano = filter_input(INPUT_POST, 'tiene_hermano');
$nivel_hermano = filter_input(INPUT_POST, 'nivel_hermano');
$sala_hermano = filter_input(INPUT_POST, 'sala_hermano');
$turno_hermano = filter_input(INPUT_POST, 'turno_hermano');
$nombre_hermano = filter_input(INPUT_POST, 'nombre_hermano');
$apellido_hermano = filter_input(INPUT_POST, 'apellido_hermano');
$dni_hermano = filter_input(INPUT_POST, 'dni_hermano');

$familiar_institucion = filter_input(INPUT_POST, 'familiar_institucion');

$alumno_incompleto = false;
$padre_incompleto = false;
$madre_incompleta = false;
$hermano_incompleto = false;
$email_incorrecto = false;
$ningun_telefono = false;

if (empty($nivel) || empty($sala) || empty($turno) 
|| empty($nombre) || empty($apellido) || empty($dni) || empty($fecha_nac) || empty($direccion)) {
    $alumno_incompleto = true;
}
    
if (empty($nombre_padre) || empty($apellido_padre) || empty($dni_padre) || empty($mail_padre) 
|| empty($direccion_padre) || empty($actividad_padre) ) {
    $padre_incompleto = true;
}

if (empty($nombre_madre) || empty($apellido_madre) || empty($dni_madre) || empty($mail_madre) 
|| empty($direccion_madre) || empty($actividad_madre) ) {
    $madre_incompleta = true;
}

if (empty($nivel_hermano) || empty($sala_hermano) || empty($turno_hermano) 
|| empty($nombre_hermano) || empty($apellido_hermano) || empty($dni_hermano)) {
    $hermano_incompleto = true;
}

// Datos del padre para el from del correo
$mailPadre = empty($mail_padre) ? $mail_madre : $mail_padre;
$namePadre = empty($nombre_padre) ? $nombre_madre . " " . $apellido_madre : $nombre_padre . " " . $apellido_padre;

if (!filter_var($mailPadre, FILTER_VALIDATE_EMAIL)) {
    $email_incorrecto = true;
}

//Validar la presencia de al menos un teléfono
if (empty($telefono_padre) && empty($telefono_madre) && empty($celular_padre) && empty($celular_madre)) {
    $ningun_telefono = true;
}

if ($alumno_incompleto 
|| ($padre_incompleto && $madre_incompleta) 
|| ($tiene_hermano && $hermano_incompleto)
|| $email_incorrecto || $ningun_telefono) {
    include("formulario.php");
    exit();
}

/*
* Importación de las librerías necesarias:
*
*   PHPMailer   - Para el envío del mail.
*   Html2Pdf    - Para la generación del PDF adjunto.
*/
require("class.phpmailer.php");
require("class.smtp.php");
require __DIR__.'/vendor/autoload.php';
use Spipu\Html2Pdf\Html2Pdf;


// Generación del PDF
ob_start();
require_once 'vista_pdf.php';
$html = ob_get_clean();

$html2pdf = new Html2Pdf('P', 'A4', 'en', true, 'UTF-8', array(20, 20, 20, 0));
$html2pdf->writeHTML($html);
$pdf = $html2pdf->Output("","S");



// $nombre = $_POST["nombre"];
// $email = $_POST["email"];
// $asunto = $_POST["asunto"];
// $mensaje = $_POST["mensaje"];
// $archivo = $_FILES["adjunto"];



// Casilla de correo que va a recibir los mails desde el formulario
$destinatario = "preinscripciones@ipei1291.edu.ar";

// Datos de la cuenta de correo utilizada para enviar vía SMTP
$smtpHost = "mail.ipei1291.edu.ar";                     // Dominio alternativo brindado por el hosting
$smtpUsuario = "preinscripciones@ipei1291.edu.ar";      // Cuenta de correo
$smtpClave = "QXN%FN2?[9ZH";                            // Contraseña

// Creación del mail
$mail = new PHPMailer();
$mail->IsSMTP();
$mail->SMTPAuth = true;
$mail->Port = 587; 
$mail->IsHTML(true); 
$mail->CharSet = "utf-8";

$mail->Host = $smtpHost; 
$mail->Username = $smtpUsuario; 
$mail->Password = $smtpClave;

$mail->From = $mailPadre;                                    // Email del que completa el formulario
$mail->FromName = $namePadre;                                // Nombre del que completa el formulario
$mail->AddAddress($destinatario);                           // Destinatario del mail
// $mail->AddAddress("maurosjuarez@outlook.com");
$mail->Subject = "Nueva Preinscripción 2021 Nivel " . $nivel;   // Título del mail


// Texto del email en formato HTML
$mail->Body = "Se adjunta la planilla de preinscripción para el Nivel "
. $nivel . " de " . $nombre . " " . $apellido . ", DNI N° " . $dni . "." ;

// Texto sin formato HTML
$mail->AltBody = "Se adjunta la planilla de preinscripción para el Nivel "
. $nivel . " de " . $nombre . " " . $apellido . ", DNI N° " . $dni . "." ;



// Adjuntar un archivo
// $mail->AddAttachment($archivo['tmp_name'], $archivo['name']);

// Adjuntar el PDF generado
$mail->addStringAttachment($pdf, $nombre.$apellido.$dni.$nivel.$sala.$turno.'.pdf');


// Opciones de seguridad
$mail->SMTPOptions = array(
    'ssl' => array(
        'verify_peer' => false,
        'verify_peer_name' => false,
        'allow_self_signed' => true
    )
);


$estadoEnvio = $mail->Send();   // Enviar el mail 


//Enviar un mail de confirmación al usuario
$mail->ClearAddresses();

$mail->From = "ipeiadmin@fibercorp.com.ar"; //Acá va el mail de administración de la escuela
$mail->FromName = "IPEI Leonardo Da Vinci - Santa Fe"; 
$mail->AddAddress($mailPadre);
$mail->Body = "Buen día, la planilla de preincripción se ha enviado con éxito. 
Recuerde que este formulario será dirigido a la Administración quien convocará a 
una entrevista según vacantes disponibles por nivel. 
Completar dicho formulario no asegura la inscripción. Saludos.";
$mail->addStringAttachment($pdf, $nombre.$apellido.$dni.$nivel.$sala.$turno.'.pdf');

$estadoEnvioUsuario = $mail->Send();   // Enviar el mail 

if($estadoEnvio && $estadoEnvioUsuario){
    # echo "El correo fue enviado correctamente.";
    include("planillaenviada.php");
    exit();
} else {
    echo "Ocurrió un error inesperado.";
}



?>

